/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.economy;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class EconomyMessagesManager {
    private final JavaPlugin plugin;
    private final File file;
    private FileConfiguration config;
    private final Map<String, String> messages = new HashMap<String, String>();
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public EconomyMessagesManager(JavaPlugin plugin) {
        this.plugin = plugin;
        File folder = new File(plugin.getDataFolder(), "messages");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        this.file = new File(folder, "Economy.yml");
        if (!this.file.exists()) {
            plugin.saveResource("messages/Economy.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.loadMessages();
    }

    private void loadMessages() {
        this.messages.clear();
        for (String key : this.config.getKeys(true)) {
            if (!this.config.isString(key)) continue;
            this.messages.put(key, this.config.getString(key));
        }
    }

    public void reload() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.loadMessages();
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Component getMessage(String key, Map<String, String> placeholders) {
        String raw = this.messages.getOrDefault(key, "<red>Missing message: " + key);
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                raw = raw.replace("%" + entry.getKey() + "%", entry.getValue());
            }
        }
        return this.miniMessage.deserialize(raw);
    }

    public Component getMessage(String key) {
        return this.getMessage(key, null);
    }
}

