/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.homes;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import serveressentials.serveressentials.homes.Home;

public class HomeManager {
    private final Plugin plugin;
    private final File file;
    private FileConfiguration config;
    private final Map<UUID, Map<Integer, Home>> homes = new HashMap<UUID, Map<Integer, Home>>();

    public HomeManager(Plugin plugin) {
        this.plugin = plugin;
        File storageFolder = new File(plugin.getDataFolder(), "storage");
        if (!storageFolder.exists()) {
            storageFolder.mkdirs();
        }
        this.file = new File(storageFolder, "homes.yml");
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                plugin.getLogger().severe("Could not create storage/homes.yml");
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.loadAll();
    }

    public synchronized void loadAll() {
        this.homes.clear();
        ConfigurationSection root = this.config.getConfigurationSection("players");
        if (root == null) {
            return;
        }
        for (String uuidStr : root.getKeys(false)) {
            UUID uuid = UUID.fromString(uuidStr);
            ConfigurationSection playerSec = root.getConfigurationSection(uuidStr);
            if (playerSec == null) continue;
            HashMap<Integer, Home> map = new HashMap<Integer, Home>();
            for (String idx : playerSec.getKeys(false)) {
                try {
                    int i = Integer.parseInt(idx);
                    ConfigurationSection hs = playerSec.getConfigurationSection(idx);
                    if (hs == null) continue;
                    Home h2 = new Home();
                    h2.setName(hs.getString("name", "Home" + idx));
                    h2.setLocation(Bukkit.getWorld((String)hs.getString("world")) != null ? new Location(Bukkit.getWorld((String)hs.getString("world")), hs.getDouble("x"), hs.getDouble("y"), hs.getDouble("z"), (float)hs.getDouble("yaw", 0.0), (float)hs.getDouble("pitch", 0.0)) : null);
                    map.put(i, h2);
                }
                catch (Exception exception) {}
            }
            this.homes.put(uuid, map);
        }
    }

    public synchronized void saveAll() {
        this.config.set("players", null);
        for (Map.Entry<UUID, Map<Integer, Home>> e : this.homes.entrySet()) {
            String uuid = e.getKey().toString();
            for (Map.Entry<Integer, Home> hentry : e.getValue().entrySet()) {
                String base = "players." + uuid + "." + String.valueOf(hentry.getKey());
                Home h2 = hentry.getValue();
                this.config.set(base + ".name", (Object)h2.getName());
                Location loc = h2.toLocation();
                if (loc == null) continue;
                this.config.set(base + ".world", (Object)loc.getWorld().getName());
                this.config.set(base + ".x", (Object)loc.getX());
                this.config.set(base + ".y", (Object)loc.getY());
                this.config.set(base + ".z", (Object)loc.getZ());
                this.config.set(base + ".yaw", (Object)Float.valueOf(loc.getYaw()));
                this.config.set(base + ".pitch", (Object)Float.valueOf(loc.getPitch()));
            }
        }
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save storage/homes.yml");
            e.printStackTrace();
        }
    }

    public synchronized Optional<Home> getHome(UUID player, int slot) {
        Map<Integer, Home> map = this.homes.get(player);
        if (map == null) {
            return Optional.empty();
        }
        Home h2 = map.get(slot);
        return Optional.ofNullable(h2);
    }

    public synchronized void setHome(UUID player, int slot, Home home) {
        this.homes.computeIfAbsent(player, k -> new HashMap()).put(slot, home);
        this.saveAll();
    }

    public synchronized void removeHome(UUID player, int slot) {
        Map<Integer, Home> map = this.homes.get(player);
        if (map != null) {
            map.remove(slot);
            this.saveAll();
        }
    }

    public synchronized Map<Integer, Home> getAllHomes(UUID player) {
        return this.homes.getOrDefault(player, Collections.emptyMap());
    }

    public synchronized int countHomes(UUID player) {
        return this.homes.getOrDefault(player, Collections.emptyMap()).size();
    }
}

