/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.listeners;

import java.io.File;
import java.util.List;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerListPingEvent;
import serveressentials.serveressentials.ServerEssentials;

public class MotdListener
implements Listener {
    private final ServerEssentials plugin;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private static final int CHAT_LINE_WIDTH = 60;

    public MotdListener(ServerEssentials plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onServerListPing(ServerListPingEvent event) {
        File motdFile = new File(this.plugin.getDataFolder(), "motd.yml");
        if (!motdFile.exists()) {
            return;
        }
        FileConfiguration motdConfig = this.plugin.getServerMessages().getConfig();
        List lines = motdConfig.getStringList("motd");
        if (lines == null || lines.isEmpty()) {
            return;
        }
        StringBuilder motdBuilder = new StringBuilder();
        for (Object line : lines) {
            int spaces;
            boolean centered = false;
            if (((String)line).startsWith("[centered]")) {
                centered = true;
                line = ((String)line).replaceFirst("\\[centered\\]", "");
            }
            if (centered && (spaces = (60 - ((String)line).length()) / 2) > 0) {
                line = " ".repeat(spaces) + (String)line;
            }
            motdBuilder.append((String)line).append("\n");
        }
        event.setMotd(motdBuilder.toString().trim());
    }
}

