/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.lobby;

import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import serveressentials.serveressentials.ServerEssentials;

public class LobbyManager {
    private static File file;
    private static FileConfiguration config;
    private static Location lobby;

    public static void setup() {
        File dataFolder = ServerEssentials.getInstance().getDataFolder();
        File storageFolder = new File(dataFolder, "storage");
        if (!storageFolder.exists()) {
            storageFolder.mkdirs();
        }
        if (!(file = new File(storageFolder, "lobby.yml")).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                Bukkit.getLogger().severe("[ServerEssentials] Failed to create lobby.yml!");
                e.printStackTrace();
            }
        }
        config = YamlConfiguration.loadConfiguration((File)file);
        lobby = config.getLocation("lobby");
    }

    public static void loadLobby() {
        if (file == null || config == null) {
            LobbyManager.setup();
        }
        lobby = config.getLocation("lobby");
    }

    public static void setLobby(Location location) {
        lobby = location;
        config.set("lobby", (Object)location);
        LobbyManager.save();
    }

    public static Location getLobby() {
        if (lobby == null) {
            LobbyManager.loadLobby();
        }
        return lobby;
    }

    public static void removeLobby() {
        lobby = null;
        config.set("lobby", null);
        LobbyManager.save();
    }

    public static boolean hasLobby() {
        return LobbyManager.getLobby() != null;
    }

    private static void save() {
        try {
            config.save(file);
        }
        catch (IOException e) {
            Bukkit.getLogger().severe("[ServerEssentials] Failed to save lobby.yml!");
            e.printStackTrace();
        }
    }
}

