/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.pw;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import serveressentials.serveressentials.config.GUIConfig;
import serveressentials.serveressentials.gui.CategoryGUI;
import serveressentials.serveressentials.gui.EditWarpGUI;
import serveressentials.serveressentials.gui.WarpListGUI;
import serveressentials.serveressentials.pw.PlayerWarp;
import serveressentials.serveressentials.pw.WarpStorage;
import serveressentials.serveressentials.util.ChatUtil;

public class GUIListeners
implements Listener {
    private final WarpStorage storage;
    private final Plugin plugin;
    private final GUIConfig guiConfig;
    private final Map<UUID, Consumer<String>> chatInputs = new HashMap<UUID, Consumer<String>>();
    private final Map<UUID, PlayerWarp> awaitingCategorySelection = new HashMap<UUID, PlayerWarp>();

    public GUIListeners(WarpStorage storage, Plugin plugin, GUIConfig guiConfig) {
        this.storage = storage;
        this.plugin = plugin;
        this.guiConfig = guiConfig;
    }

    public void waitForChatInput(Player player, Consumer<String> handler) {
        this.chatInputs.put(player.getUniqueId(), handler);
    }

    @EventHandler
    public void onWarpClick(InventoryClickEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = e.getView().getTitle();
        String warpsPrefix = this.guiConfig.getWarpsGUITitlePrefix();
        if (!title.startsWith(warpsPrefix)) {
            return;
        }
        e.setCancelled(true);
        ItemStack clicked = e.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String name = ChatColor.stripColor((String)clicked.getItemMeta().getDisplayName());
        String category = title.substring(warpsPrefix.length());
        PlayerWarp warp = this.storage.getWarpsInCategory(category).stream().filter(w -> ChatColor.stripColor((String)w.getName()).equalsIgnoreCase(name)).findFirst().orElse(null);
        if (warp == null) {
            player.sendMessage(ChatUtil.color(this.guiConfig.getMessage("warp-not-found", "\u00a7cWarp not found.")));
            return;
        }
        player.teleport(warp.getLocation());
        player.sendMessage(ChatUtil.color(this.guiConfig.getMessage("teleport-success", "\u00a7aTeleported to &f" + warp.getName())));
    }

    @EventHandler
    public void onEditClick(InventoryClickEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String titlePrefix = this.guiConfig.getEditWarpGUITitlePrefix();
        if (!e.getView().getTitle().startsWith(titlePrefix)) {
            return;
        }
        e.setCancelled(true);
        ItemStack clicked = e.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        PlayerWarp warp = this.storage.getEditingWarp(player);
        if (warp == null) {
            player.sendMessage(ChatUtil.color(this.guiConfig.getMessage("warp-editing-none", "\u00a7cCould not find warp being edited.")));
            return;
        }
        int slot = e.getSlot();
        switch (slot) {
            case 10: {
                player.closeInventory();
                player.sendMessage(ChatUtil.color(this.guiConfig.getMessage("edit-warp-type-name", "\u00a7eType the new warp name in chat:")));
                this.waitForChatInput(player, input -> {
                    if (input.isBlank()) {
                        player.sendMessage(ChatUtil.color(this.guiConfig.getMessage("edit-warp-name-empty", "\u00a7cName cannot be empty.")));
                        return;
                    }
                    warp.setName((String)input);
                    player.sendMessage(ChatUtil.color(this.guiConfig.getMessage("edit-warp-name-updated", "\u00a7aWarp name updated.")));
                    new EditWarpGUI(this.storage, this.guiConfig).open(player, warp);
                });
                break;
            }
            case 11: {
                player.closeInventory();
                player.sendMessage(ChatUtil.color(this.guiConfig.getMessage("edit-warp-type-description", "\u00a7eType the new description in chat:")));
                this.waitForChatInput(player, input -> {
                    warp.setDescription((String)input);
                    player.sendMessage(ChatUtil.color(this.guiConfig.getMessage("edit-warp-description-updated", "\u00a7aWarp description updated.")));
                    new EditWarpGUI(this.storage, this.guiConfig).open(player, warp);
                });
                break;
            }
            case 12: {
                this.awaitingCategorySelection.put(player.getUniqueId(), warp);
                new CategoryGUI(this.storage, this.guiConfig).open(player);
                break;
            }
            case 13: {
                player.closeInventory();
                player.sendMessage(ChatUtil.color(this.guiConfig.getMessage("edit-warp-icon-instruction", "\u00a7eHold the item you want as icon and type 'icon' in chat.")));
                this.waitForChatInput(player, input -> {
                    if (!input.equalsIgnoreCase("icon")) {
                        player.sendMessage(ChatUtil.color(this.guiConfig.getMessage("edit-warp-icon-invalid", "\u00a7cInvalid input, type 'icon' to set icon.")));
                        return;
                    }
                    ItemStack hand = player.getInventory().getItemInMainHand();
                    if (hand == null || hand.getType() == Material.AIR) {
                        player.sendMessage(ChatUtil.color(this.guiConfig.getMessage("edit-warp-icon-no-item", "\u00a7cHold an item in your hand.")));
                        return;
                    }
                    warp.setIcon(hand.getType());
                    player.sendMessage(ChatUtil.color(this.guiConfig.getMessage("edit-warp-icon-updated", "\u00a7aWarp icon updated.")));
                    new EditWarpGUI(this.storage, this.guiConfig).open(player, warp);
                });
                break;
            }
            case 14: {
                warp.setLocation(player.getLocation());
                player.sendMessage(ChatUtil.color(this.guiConfig.getMessage("edit-warp-location-updated", "\u00a7aWarp location updated.")));
                new EditWarpGUI(this.storage, this.guiConfig).open(player, warp);
                break;
            }
            case 15: {
                player.closeInventory();
                player.sendMessage(ChatUtil.color(this.guiConfig.getMessage("edit-warp-type-cooldown", "\u00a7eType the new cooldown time in seconds:")));
                this.waitForChatInput(player, input -> {
                    try {
                        int cd2 = Integer.parseInt(input);
                        if (cd2 < 0) {
                            throw new NumberFormatException();
                        }
                        warp.setCooldownSeconds(cd2);
                        player.sendMessage(ChatUtil.color(this.guiConfig.getMessage("edit-warp-cooldown-updated", "\u00a7aWarp cooldown updated.")));
                    }
                    catch (NumberFormatException ex) {
                        player.sendMessage(ChatUtil.color(this.guiConfig.getMessage("edit-warp-cooldown-invalid", "\u00a7cInvalid number.")));
                    }
                    new EditWarpGUI(this.storage, this.guiConfig).open(player, warp);
                });
            }
        }
    }

    @EventHandler
    public void onCategoryClick(InventoryClickEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String categoryTitle = this.guiConfig.getCategoryGUITitle();
        if (!e.getView().getTitle().equals(categoryTitle)) {
            return;
        }
        e.setCancelled(true);
        ItemStack clicked = e.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String category = ChatColor.stripColor((String)clicked.getItemMeta().getDisplayName());
        if (this.awaitingCategorySelection.containsKey(player.getUniqueId())) {
            PlayerWarp warp = this.awaitingCategorySelection.remove(player.getUniqueId());
            warp.setCategory(category);
            player.sendMessage(ChatUtil.color(this.guiConfig.getMessage("category-set-success", "\u00a7aWarp category set to " + category)));
            new EditWarpGUI(this.storage, this.guiConfig).open(player, warp);
        } else {
            new WarpListGUI(this.storage, this.guiConfig).open(player, category);
        }
    }

    @EventHandler
    public void onChatInput(AsyncPlayerChatEvent e) {
        Player player = e.getPlayer();
        UUID uuid = player.getUniqueId();
        if (this.chatInputs.containsKey(uuid)) {
            e.setCancelled(true);
            String message = e.getMessage();
            Consumer<String> handler = this.chatInputs.remove(uuid);
            Bukkit.getScheduler().runTask(this.plugin, () -> handler.accept(message));
        }
    }
}

