/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.scoreboard;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import serveressentials.serveressentials.scoreboard.ScoreboardCommand;
import serveressentials.serveressentials.scoreboard.ScoreboardConfig;
import serveressentials.serveressentials.scoreboard.ScoreboardDatabase;
import serveressentials.serveressentials.scoreboard.ScoreboardListener;
import serveressentials.serveressentials.scoreboard.ScoreboardStorage;
import serveressentials.serveressentials.scoreboard.ScoreboardUpdater;
import serveressentials.serveressentials.scoreboard.util.MessageUtil;

public class CustomScoreboardManager {
    private final JavaPlugin plugin;
    private final ScoreboardConfig configHandler;
    private final ScoreboardStorage storage;
    private final ScoreboardDatabase database;
    private final ScoreboardUpdater updater;
    private final MessageUtil messages;

    public CustomScoreboardManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.messages = new MessageUtil(plugin, "messages/scoreboard_system.yml");
        this.configHandler = new ScoreboardConfig(plugin);
        this.storage = new ScoreboardStorage(plugin);
        this.database = new ScoreboardDatabase(plugin);
        this.updater = new ScoreboardUpdater(this);
        plugin.getCommand("scoreboard").setExecutor((CommandExecutor)new ScoreboardCommand(this));
        Bukkit.getPluginManager().registerEvents((Listener)new ScoreboardListener(this), (Plugin)plugin);
        this.updater.start();
    }

    public void reload() {
        this.configHandler.reload();
        this.storage.reload();
        this.messages.reload();
        this.updater.refreshAll();
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public ScoreboardConfig getConfigHandler() {
        return this.configHandler;
    }

    public ScoreboardStorage getStorage() {
        return this.storage;
    }

    public ScoreboardDatabase getDatabase() {
        return this.database;
    }

    public ScoreboardUpdater getUpdater() {
        return this.updater;
    }

    public MessageUtil getMessages() {
        return this.messages;
    }
}

