/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.scoreboard;

import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ScoreboardStorage {
    private final File file;
    private YamlConfiguration config;

    public ScoreboardStorage(JavaPlugin plugin) {
        this.file = new File(plugin.getDataFolder(), "storage/scoreboard.yml");
        this.reload();
    }

    public void reload() {
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public boolean togglePlayer(Player player) {
        String path = "players." + String.valueOf(player.getUniqueId()) + ".enabled";
        boolean state = !this.config.getBoolean(path, true);
        this.config.set(path, (Object)state);
        this.save();
        return state;
    }

    public boolean isEnabled(Player player) {
        return this.config.getBoolean("players." + String.valueOf(player.getUniqueId()) + ".enabled", true);
    }

    public void setPlayerLayout(Player player, String layout) {
        this.config.set("players." + String.valueOf(player.getUniqueId()) + ".layout", (Object)layout);
        this.save();
    }

    public String getPlayerLayout(Player player) {
        return this.config.getString("players." + String.valueOf(player.getUniqueId()) + ".layout", "default");
    }

    private void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

