/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.scoreboard;

import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import serveressentials.serveressentials.scoreboard.CustomScoreboardManager;
import serveressentials.serveressentials.scoreboard.util.PlaceholderUtil;

public class ScoreboardUpdater {
    private final CustomScoreboardManager manager;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.legacySection();

    public ScoreboardUpdater(CustomScoreboardManager manager) {
        this.manager = manager;
    }

    public void start() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    ScoreboardUpdater.this.update(player);
                }
            }
        }.runTaskTimer((Plugin)this.manager.getPlugin(), 20L, 40L);
    }

    public void refreshAll() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.update(player);
        }
    }

    public void clear(Player player) {
        player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
    }

    public void update(Player player) {
        String layout = this.manager.getConfigHandler().getLayoutForPlayer(player, this.manager.getStorage());
        this.update(player, layout);
    }

    public void update(Player player, String layout) {
        if (!this.manager.getStorage().isEnabled(player)) {
            return;
        }
        String world = player.getWorld().getName();
        if (!this.manager.getConfigHandler().isWorldEnabled(world)) {
            return;
        }
        String rawTitle = PlaceholderUtil.apply(player, this.manager.getConfigHandler().getTitle(layout));
        Object titleComponent = this.miniMessage.deserialize(rawTitle);
        List<String> rawLines = this.manager.getConfigHandler().getLines(layout);
        Scoreboard board = Bukkit.getScoreboardManager().getNewScoreboard();
        Objective obj = board.registerNewObjective("sidebar", "dummy", this.legacySerializer.serialize((Component)titleComponent));
        obj.setDisplaySlot(DisplaySlot.SIDEBAR);
        int score = rawLines.size();
        int index = 0;
        for (String line : rawLines) {
            String replaced = PlaceholderUtil.apply(player, line);
            Object lineComponent = this.miniMessage.deserialize(replaced);
            String entryKey = "\u00a7" + index;
            Team team = board.getTeam("line" + index);
            if (team == null) {
                team = board.registerNewTeam("line" + index);
            }
            if (!team.hasEntry(entryKey)) {
                team.addEntry(entryKey);
            }
            String legacy = this.legacySerializer.serialize((Component)lineComponent);
            String[] parts = this.splitLegacyText(legacy);
            team.prefix((Component)this.legacySerializer.deserialize(parts[0]));
            team.suffix((Component)this.legacySerializer.deserialize(parts[1]));
            obj.getScore(entryKey).setScore(score--);
            ++index;
        }
        player.setScoreboard(board);
    }

    private String[] splitLegacyText(String legacy) {
        StringBuilder prefix = new StringBuilder();
        StringBuilder suffix = new StringBuilder();
        Object lastColor = "";
        int visible = 0;
        for (int i = 0; i < legacy.length(); ++i) {
            char c = legacy.charAt(i);
            if (c == '\u00a7' && i + 1 < legacy.length()) {
                lastColor = "\u00a7" + legacy.charAt(i + 1);
                if (visible < 16) {
                    prefix.append((String)lastColor);
                } else if (visible < 32) {
                    suffix.append((String)lastColor);
                }
                ++i;
                continue;
            }
            if (visible < 16) {
                prefix.append(c);
            } else {
                if (visible >= 32) break;
                suffix.append(c);
            }
            ++visible;
        }
        if (!((String)lastColor).isEmpty() && !suffix.toString().startsWith("\u00a7")) {
            suffix.insert(0, (String)lastColor);
        }
        return new String[]{prefix.toString(), suffix.toString()};
    }
}

