/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.staff;

import java.net.InetAddress;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.util.MessagesManager;

public class AltsCommand
implements CommandExecutor {
    private final MessagesManager messages;

    public AltsCommand(ServerEssentials plugin) {
        this.messages = new MessagesManager(plugin);
        this.messages.addDefault("alts.usage", "<red>Usage: /alts <player>");
        this.messages.addDefault("alts.player-offline", "<red>Player must be online to check their IP.");
        this.messages.addDefault("alts.header", "<yellow>Players with the same IP as %player%:");
        this.messages.addDefault("alts.none", "<gray>- None found online.");
        this.messages.addDefault("alts.found", "<gray>- %player%");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length != 1) {
            sender.sendMessage(this.messages.getMessageComponent("alts.usage", new String[0]));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            sender.sendMessage(this.messages.getMessageComponent("alts.player-offline", new String[0]));
            return true;
        }
        InetAddress targetIP = target.getAddress().getAddress();
        ArrayList<String> matchedPlayers = new ArrayList<String>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player.equals((Object)target) || !player.getAddress().getAddress().equals(targetIP)) continue;
            matchedPlayers.add(player.getName());
        }
        sender.sendMessage(this.messages.getMessageComponent("alts.header", "%player%", target.getName()));
        if (matchedPlayers.isEmpty()) {
            sender.sendMessage(this.messages.getMessageComponent("alts.none", new String[0]));
        } else {
            for (String name : matchedPlayers) {
                sender.sendMessage(this.messages.getMessageComponent("alts.found", "%player%", name));
            }
        }
        return true;
    }
}

