/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.staff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.staff.BanManager;
import serveressentials.serveressentials.util.MessagesManager;

public class BanCommand
implements CommandExecutor,
TabCompleter {
    private final BanManager banManager;
    private final MessagesManager messages;
    private final BukkitAudiences adventure;

    public BanCommand(BanManager banManager, ServerEssentials plugin) {
        this.banManager = banManager;
        this.messages = new MessagesManager(plugin);
        this.adventure = BukkitAudiences.create((Plugin)plugin);
        this.messages.addDefault("ban.no-permission", "<red>You don't have permission.");
        this.messages.addDefault("ban.usage", "<red>Usage: /ban <player> <time> <reason>");
        this.messages.addDefault("ban.never-joined", "<red>That player has never joined the server.");
        this.messages.addDefault("ban.invalid-time", "<red>Invalid time format. Use <yellow>s/m/h/d</yellow> or <yellow>perm</yellow>");
        this.messages.addDefault("ban.success", "<green><player> has been banned.");
        this.messages.addDefault("ban.kick-message", "<red>You have been banned!\n<gray>Reason: <reason>\n<gray>Banned by: <banner>\n<gray>Until: <until>");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("serveressentials.ban.use")) {
            this.send(sender, this.messages.getMessageComponent("ban.no-permission", new String[0]));
            return true;
        }
        if (args.length < 3) {
            this.send(sender, this.messages.getMessageComponent("ban.usage", new String[0]));
            return true;
        }
        String targetName = args[0];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        if (target == null || target.getName() == null) {
            this.send(sender, this.messages.getMessageComponent("ban.never-joined", new String[0]));
            return true;
        }
        UUID uuid = target.getUniqueId();
        String name = target.getName();
        long duration = this.parseTime(args[1]);
        if (duration == -2L) {
            this.send(sender, this.messages.getMessageComponent("ban.invalid-time", new String[0]));
            return true;
        }
        String reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        String bannedBy = sender instanceof Player ? ((Player)sender).getName() : "Console";
        long until = duration == -1L ? -1L : System.currentTimeMillis() + duration;
        this.banManager.banPlayer(uuid, name, reason, bannedBy, until);
        if (target.isOnline()) {
            Component kickMsg = this.messages.getMessageComponent("ban.kick-message", "<player>", name, "<reason>", reason, "<banner>", bannedBy, "<until>", until == -1L ? "Forever" : new Date(until).toString());
            ((Player)target).kick(kickMsg);
        }
        this.send(sender, this.messages.getMessageComponent("ban.success", "<player>", name));
        return true;
    }

    private long parseTime(String time) {
        if (time.equalsIgnoreCase("perm")) {
            return -1L;
        }
        try {
            long num = Long.parseLong(time.substring(0, time.length() - 1));
            char unit = time.charAt(time.length() - 1);
            return switch (unit) {
                case 's' -> num * 1000L;
                case 'm' -> num * 60L * 1000L;
                case 'h' -> num * 60L * 60L * 1000L;
                case 'd' -> num * 24L * 60L * 60L * 1000L;
                default -> -2L;
            };
        }
        catch (Exception e) {
            return -2L;
        }
    }

    private void send(CommandSender sender, Component message) {
        this.adventure.sender(sender).sendMessage(message);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("ban.use")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            ArrayList<String> matches = new ArrayList<String>();
            for (Player online : Bukkit.getOnlinePlayers()) {
                if (!online.getName().toLowerCase().startsWith(input)) continue;
                matches.add(online.getName());
            }
            return matches;
        }
        if (args.length == 2) {
            List<String> timeOptions = Arrays.asList("30s", "1m", "5m", "1h", "1d", "perm");
            ArrayList<String> matches = new ArrayList<String>();
            for (String option : timeOptions) {
                if (!option.startsWith(args[1].toLowerCase())) continue;
                matches.add(option);
            }
            return matches;
        }
        if (args.length == 3) {
            List<String> reasons = Arrays.asList("Griefing", "Abuse", "Cheating", "Spamming");
            String input = args[2].toLowerCase();
            ArrayList<String> matches = new ArrayList<String>();
            for (String reason : reasons) {
                if (!reason.toLowerCase().startsWith(input)) continue;
                matches.add(reason);
            }
            return matches;
        }
        return Collections.emptyList();
    }
}

