/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.staff;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import serveressentials.serveressentials.ServerEssentials;

public class BanManager {
    private final ServerEssentials plugin;
    private File banFile;
    private FileConfiguration banConfig;
    private File configFile;
    private FileConfiguration config;

    public BanManager(ServerEssentials plugin) {
        this.plugin = plugin;
        this.setupBanFile();
        this.setupConfigFile();
    }

    private void setupBanFile() {
        this.banFile = new File(this.plugin.getDataFolder(), "storage/bans.yml");
        if (!this.banFile.exists()) {
            this.banFile.getParentFile().mkdirs();
            try {
                this.banFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.banConfig = YamlConfiguration.loadConfiguration((File)this.banFile);
    }

    private void setupConfigFile() {
        this.configFile = new File(this.plugin.getDataFolder(), "config/bans/bans.yml");
        if (!this.configFile.exists()) {
            this.configFile.getParentFile().mkdirs();
            try {
                this.configFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        boolean changed = false;
        if (!this.config.contains("server-name")) {
            this.config.set("server-name", (Object)"MyCoolServer");
            changed = true;
        }
        if (!this.config.contains("discord-link")) {
            this.config.set("discord-link", (Object)"https://discord.gg/example");
            changed = true;
        }
        if (changed) {
            this.saveConfig();
        }
    }

    public void banPlayer(UUID uuid, String name, String reason, String bannedBy, long until) {
        String path = "BannedPlayers." + String.valueOf(uuid);
        this.banConfig.set(path + ".name", (Object)name);
        this.banConfig.set(path + ".reason", (Object)reason);
        this.banConfig.set(path + ".bannedBy", (Object)bannedBy);
        this.banConfig.set(path + ".server", (Object)this.config.getString("server-name"));
        this.banConfig.set(path + ".discord", (Object)this.config.getString("discord-link"));
        this.banConfig.set(path + ".bannedUntil", (Object)until);
        this.saveBans();
    }

    public boolean isBanned(UUID uuid) {
        String path = "BannedPlayers." + String.valueOf(uuid);
        if (!this.banConfig.contains(path)) {
            return false;
        }
        long until = this.banConfig.getLong(path + ".bannedUntil");
        if (until == -1L) {
            return true;
        }
        if (System.currentTimeMillis() > until) {
            this.unbanPlayer(uuid);
            return false;
        }
        return true;
    }

    public void unbanPlayer(UUID uuid) {
        this.banConfig.set("BannedPlayers." + String.valueOf(uuid), null);
        this.saveBans();
    }

    public String getBanMessage(UUID uuid) {
        String path = "BannedPlayers." + String.valueOf(uuid);
        if (!this.banConfig.contains(path)) {
            return "\u00a7cYou are banned from this server.";
        }
        String reason = this.banConfig.getString(path + ".reason", "No reason specified.");
        String bannedBy = this.banConfig.getString(path + ".bannedBy", "Unknown");
        String server = this.config.getString("server-name", "Server");
        String discord = this.config.getString("discord-link", "N/A");
        long until = this.banConfig.getLong(path + ".bannedUntil");
        String timeLeft = until == -1L ? "Permanent" : new Date(until).toString();
        return "\u00a7cYou are banned from \u00a74" + server + "\n\u00a77Banned by: \u00a7f" + bannedBy + "\n\u00a77Reason: \u00a7f" + reason + "\n\u00a77Until: \u00a7f" + timeLeft + "\n\n\u00a77Appeal at: \u00a79" + discord;
    }

    public UUID getUUIDFromName(String name) {
        if (this.banConfig.contains("BannedPlayers")) {
            for (String key : this.banConfig.getConfigurationSection("BannedPlayers").getKeys(false)) {
                String storedName = this.banConfig.getString("BannedPlayers." + key + ".name");
                if (storedName == null || !storedName.equalsIgnoreCase(name)) continue;
                try {
                    return UUID.fromString(key);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return null;
    }

    public Set<String> getAllBannedUUIDs() {
        if (this.banConfig.contains("BannedPlayers")) {
            return this.banConfig.getConfigurationSection("BannedPlayers").getKeys(false);
        }
        return Collections.emptySet();
    }

    public String getNameFromUUID(String uuid) {
        return this.banConfig.getString("BannedPlayers." + uuid + ".name", "Unknown");
    }

    public String getReason(String uuid) {
        return this.banConfig.getString("BannedPlayers." + uuid + ".reason", "No reason specified");
    }

    public long getUntil(String uuid) {
        return this.banConfig.getLong("BannedPlayers." + uuid + ".bannedUntil", -1L);
    }

    private void saveBans() {
        try {
            this.banConfig.save(this.banFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

