/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.staff;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.util.MessagesManager;

public class MuteCommand
implements CommandExecutor {
    private static final Map<UUID, String> mutedPlayers = new HashMap<UUID, String>();
    private final MessagesManager messages;
    private final File muteFile;
    private final FileConfiguration muteConfig;

    public MuteCommand(ServerEssentials plugin) {
        this.messages = new MessagesManager(plugin);
        this.messages.addDefault("mute.no-permission", "<red>You don't have permission.");
        this.messages.addDefault("mute.usage", "<yellow>Usage: /mute <player> <reason>");
        this.messages.addDefault("mute.not-found", "<red>Player not found.");
        this.messages.addDefault("mute.already-muted", "<red><player> is already muted for <reason>.");
        this.messages.addDefault("mute.success", "<yellow>You muted <green><player></green> <gray>for <reason>.");
        this.messages.addDefault("mute.notify", "<red>You have been muted! <gray>Reason: <reason>");
        this.muteFile = new File(plugin.getDataFolder(), "storage/mutes.yml");
        if (!this.muteFile.exists()) {
            try {
                this.muteFile.getParentFile().mkdirs();
                this.muteFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.muteConfig = YamlConfiguration.loadConfiguration((File)this.muteFile);
        if (this.muteConfig.contains("mutes")) {
            for (String uuidString : this.muteConfig.getConfigurationSection("mutes").getKeys(false)) {
                String reason = this.muteConfig.getString("mutes." + uuidString + ".reason", "No reason");
                mutedPlayers.put(UUID.fromString(uuidString), reason);
            }
        }
    }

    public static void unmute(UUID uuid, MessagesManager messages) {
        if (!mutedPlayers.containsKey(uuid)) {
            return;
        }
        mutedPlayers.remove(uuid);
        File muteFile = new File(ServerEssentials.getInstance().getDataFolder(), "storage/mutes.yml");
        YamlConfiguration muteConfig = YamlConfiguration.loadConfiguration((File)muteFile);
        muteConfig.set("mutes." + String.valueOf(uuid), null);
        try {
            muteConfig.save(muteFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null && player.isOnline()) {
            player.sendMessage(messages.getMessageComponent("unmute.notify", new String[0]));
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!sender.hasPermission("serveressentials.mute")) {
            sender.sendMessage(this.messages.getMessageComponent("mute.no-permission", new String[0]));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.messages.getMessageComponent("mute.usage", new String[0]));
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null) {
            sender.sendMessage(this.messages.getMessageComponent("mute.not-found", new String[0]));
            return true;
        }
        String reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        if (mutedPlayers.containsKey(target.getUniqueId())) {
            sender.sendMessage(this.messages.getMessageComponent("mute.already-muted", "<player>", target.getName(), "<reason>", mutedPlayers.get(target.getUniqueId())));
            return true;
        }
        mutedPlayers.put(target.getUniqueId(), reason);
        this.muteConfig.set("mutes." + String.valueOf(target.getUniqueId()) + ".reason", (Object)reason);
        this.saveMutes();
        sender.sendMessage(this.messages.getMessageComponent("mute.success", "<player>", target.getName(), "<reason>", reason));
        target.sendMessage(this.messages.getMessageComponent("mute.notify", "<reason>", reason));
        return true;
    }

    private void saveMutes() {
        try {
            this.muteConfig.save(this.muteFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isMuted(UUID uuid) {
        return mutedPlayers.containsKey(uuid);
    }

    public static String getMuteReason(UUID uuid) {
        return mutedPlayers.getOrDefault(uuid, "No reason");
    }
}

