/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.staff;

import java.util.ArrayList;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.util.MessagesManager;

public class StaffListCommand
implements CommandExecutor {
    private final MessagesManager messages;
    private final BukkitAudiences adventure;

    public StaffListCommand(ServerEssentials plugin) {
        this.messages = new MessagesManager(plugin);
        this.adventure = BukkitAudiences.create((Plugin)plugin);
        this.messages.addDefault("stafflist.header", "<#00ffff>--- Online Staff ---");
        this.messages.addDefault("stafflist.none", "<#aaaaaa>No staff members online.");
        this.messages.addDefault("stafflist.format", "<#00ff00>\u2022 <#ffff00><player>");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        ArrayList<String> staffOnline = new ArrayList<String>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("serveressentials.stafflist")) continue;
            staffOnline.add(player.getName());
        }
        this.send(sender, this.messages.getMessageComponent("stafflist.header", new String[0]));
        if (staffOnline.isEmpty()) {
            this.send(sender, this.messages.getMessageComponent("stafflist.none", new String[0]));
        } else {
            for (String name : staffOnline) {
                Component line = this.messages.getMessageComponent("stafflist.format", "<player>", name);
                this.send(sender, line);
            }
        }
        return true;
    }

    private void send(CommandSender sender, Component component) {
        this.adventure.sender(sender).sendMessage(component);
    }
}

