/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class DailyMessagesManager {
    private final JavaPlugin plugin;
    private FileConfiguration config;

    public DailyMessagesManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    private void loadConfig() {
        File file;
        File folder = new File(this.plugin.getDataFolder(), "messages");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!(file = new File(folder, "daily.yml")).exists()) {
            try (InputStream in = this.plugin.getResource("messages/daily.yml");){
                if (in != null) {
                    Files.copy(in, file.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)file);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public List<Map<String, Object>> getRewardItems(String day) {
        List raw = this.config.getMapList("rewards." + day + ".items");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Map map : raw) {
            list.add(map);
        }
        return list;
    }

    public String get(String path, Object ... placeholders) {
        String msg = this.config.getString(path, "<red>Message not found");
        for (int i = 0; i < placeholders.length - 1; i += 2) {
            msg = msg.replace(placeholders[i].toString(), placeholders[i + 1].toString());
        }
        return msg;
    }

    public List<String> getConfigSection(String path) {
        if (this.config.getConfigurationSection(path) == null) {
            return List.of();
        }
        return List.copyOf(this.config.getConfigurationSection(path).getKeys(false));
    }

    public int getTotalPages(List<String> keys) {
        int pages = 1;
        for (String day : keys) {
            int page = this.config.getInt("rewards." + day + ".page", 1);
            pages = Math.max(pages, page);
        }
        return pages;
    }

    public int getRewardPage(String day) {
        return this.config.getInt("rewards." + day + ".page", 1);
    }

    public int getRewardSlot(String day) {
        return this.config.getInt("rewards." + day + ".slot", 0);
    }

    public Map<String, Object> getRewardItem(String day) {
        List list = this.config.getMapList("rewards." + day + ".items");
        return list.isEmpty() ? Map.of() : (Map)list.get(0);
    }
}

