/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class DailyRewardsManager {
    private final JavaPlugin plugin;
    private FileConfiguration config;

    public DailyRewardsManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    private void loadConfig() {
        File file;
        File folder = new File(this.plugin.getDataFolder(), "config/Daily");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!(file = new File(folder, "daily.yml")).exists()) {
            try (InputStream in = this.plugin.getResource("config/Daily/daily.yml");){
                if (in != null) {
                    Files.copy(in, file.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to copy daily.yml from resources!");
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)file);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public List<String> getRewardDays() {
        if (this.config.getConfigurationSection("rewards") == null) {
            return List.of();
        }
        return new ArrayList<String>(this.config.getConfigurationSection("rewards").getKeys(false));
    }

    public List<Map<String, Object>> getRewardItems(String day) {
        List raw = this.config.getMapList("rewards." + day + ".items");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Map map : raw) {
            list.add(map);
        }
        return list;
    }

    public int getRewardPage(String day) {
        return this.config.getInt("rewards." + day + ".page", 1);
    }

    public int getRewardSlot(String day) {
        return this.config.getInt("rewards." + day + ".slot", 0);
    }

    public Map<String, Object> getFirstRewardItem(String day) {
        List<Map<String, Object>> items = this.getRewardItems(day);
        return items.isEmpty() ? Map.of() : items.get(0);
    }

    public int getTotalPages() {
        int pages = 1;
        for (String day : this.getRewardDays()) {
            pages = Math.max(pages, this.getRewardPage(day));
        }
        return pages;
    }
}

