/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.util;

import java.io.File;
import java.io.IOException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class HomeMessages {
    private final Plugin plugin;
    private final File file;
    private FileConfiguration config;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public HomeMessages(Plugin plugin, String path) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), path);
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            plugin.saveResource(path, false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.addDefault("gui.title.main", "<white><bold>Homes</bold></white>");
        this.addDefault("gui.title.confirm", "<white><bold>Confirm</bold></white>");
        this.addDefault("msg.no-permission", "<red>You don't have permission to do that.");
        this.addDefault("msg.home-set", "<green>Home <gold>{home}</gold> set at <yellow>{x}, {y}, {z}</yellow>.");
        this.addDefault("msg.home-removed", "<green>Home <gold>{home}</gold> removed.");
        this.addDefault("msg.rename-prompt", "<yellow>Type the new name for your home in chat.");
        this.addDefault("msg.renamed", "<green>Home renamed to <gold>{name}</gold>.");
        this.addDefault("msg.teleport", "<green>Teleporting to <gold>{home}</gold>...");
        this.addDefault("lore.empty", "<gray>Empty");
        this.addDefault("lore.click.set", "<green>Click to set this home.");
        this.addDefault("lore.click.remove", "<red>Click to remove this home.");
        this.addDefault("lore.click.rename", "<aqua>Click to rename this home.");
        this.save();
    }

    public void addDefault(String path, Object value) {
        if (!this.config.contains(path)) {
            this.config.set(path, value);
            this.save();
        }
    }

    public Component get(String path) {
        String raw = this.config.getString(path, "<red>Missing message: " + path);
        return this.miniMessage.deserialize(raw);
    }

    public Component get(String path, String ... placeholders) {
        String raw = this.config.getString(path, "<red>Missing message: " + path);
        if (placeholders != null && placeholders.length % 2 == 0) {
            for (int i = 0; i < placeholders.length; i += 2) {
                raw = raw.replace(placeholders[i], placeholders[i + 1]);
            }
        }
        return this.miniMessage.deserialize(raw);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save " + this.file.getName() + "!");
            e.printStackTrace();
        }
    }
}

