/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import serveressentials.serveressentials.ServerEssentials;

public class RTPMessages {
    private final ServerEssentials plugin;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private File file;
    private FileConfiguration config;

    public RTPMessages(ServerEssentials plugin) {
        this.plugin = plugin;
        this.load();
    }

    private void load() {
        this.file = new File(this.plugin.getDataFolder(), "messages/rtp.yml");
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        if (!this.file.exists()) {
            this.plugin.saveResource("messages/rtp.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void reload() {
        this.load();
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save rtp.yml!");
            e.printStackTrace();
        }
    }

    public List<Component> getList(String path, String ... placeholders) {
        List rawList = this.config.getStringList(path);
        ArrayList<Component> components = new ArrayList<Component>();
        for (String line : rawList) {
            if (placeholders != null && placeholders.length % 2 == 0) {
                for (int i = 0; i < placeholders.length; i += 2) {
                    line = line.replace(placeholders[i], placeholders[i + 1]);
                }
            }
            components.add((Component)this.miniMessage.deserialize(line));
        }
        return components;
    }

    public void addDefault(String path, String defaultMessage) {
        if (!this.config.contains(path)) {
            this.config.set(path, (Object)defaultMessage);
            this.save();
        }
    }

    public Component get(String path, String ... placeholders) {
        String msg = this.config.getString(path, "<red>Missing message: " + path);
        if (placeholders != null && placeholders.length % 2 == 0) {
            for (int i = 0; i < placeholders.length; i += 2) {
                msg = msg.replace(placeholders[i], placeholders[i + 1]);
            }
        }
        return this.miniMessage.deserialize(msg);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

