/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.utility;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.util.PlayerMessages;

public class EditSignCommand
implements CommandExecutor {
    private final MiniMessage mm = MiniMessage.miniMessage();
    private final PlayerMessages playerMessages;

    public EditSignCommand(ServerEssentials plugin) {
        this.playerMessages = new PlayerMessages(plugin);
        this.playerMessages.addDefault("EditSign.Messages.OnlyPlayers", "<red>Only players can use this command.");
        this.playerMessages.addDefault("EditSign.Messages.NotLookingAtSign", "<red>You are not looking at a sign.");
        this.playerMessages.addDefault("EditSign.Messages.Usage", "<yellow>Usage: /editsign <line1>|<line2>|<line3>|<line4>");
        this.playerMessages.addDefault("EditSign.Messages.Success", "<green>Sign updated successfully!");
    }

    private Component getMessage(String path, String ... placeholders) {
        return this.playerMessages.get(path, placeholders);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.getMessage("EditSign.Messages.OnlyPlayers", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        Block target = player.getTargetBlockExact(5);
        if (target == null || !target.getType().name().contains("SIGN")) {
            player.sendMessage(this.getMessage("EditSign.Messages.NotLookingAtSign", new String[0]));
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(this.getMessage("EditSign.Messages.Usage", new String[0]));
            return true;
        }
        String input = String.join((CharSequence)" ", args);
        String[] lines = input.split("\\|");
        Sign sign = (Sign)target.getState();
        for (int i = 0; i < Math.min(lines.length, 4); ++i) {
            String line = LegacyComponentSerializer.legacySection().serialize((Component)this.mm.deserialize(lines[i].trim()));
            sign.setLine(i, line);
        }
        sign.update();
        player.sendMessage(this.getMessage("EditSign.Messages.Success", new String[0]));
        return true;
    }
}

