/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Managers;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class AFKManager
implements Listener {
    private static Plugin plugin;
    private static File configFile;
    private static YamlConfiguration config;
    private static final Map<UUID, Long> lastActivity;
    private static final Set<UUID> afkPlayers;
    private static final Map<UUID, BossBar> bossBars;
    private static final MiniMessage mm;

    public AFKManager(Plugin pl) {
        plugin = pl;
        AFKManager.loadConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
        Bukkit.getScheduler().runTaskTimer(plugin, AFKManager::checkAFK, 20L, 20L);
    }

    private static void loadConfig() {
        configFile = new File(String.valueOf(plugin.getDataFolder()) + "/config/afk", "afk.yml");
        if (!configFile.exists()) {
            configFile.getParentFile().mkdirs();
            plugin.saveResource("config/afk/afk.yml", false);
        }
        config = YamlConfiguration.loadConfiguration((File)configFile);
    }

    public static void reload() {
        config = YamlConfiguration.loadConfiguration((File)configFile);
        Bukkit.getLogger().info("[ServerEssentials] AFK system reloaded.");
    }

    private static void updateActivity(Player player) {
        lastActivity.put(player.getUniqueId(), System.currentTimeMillis());
        if (afkPlayers.remove(player.getUniqueId())) {
            AFKManager.sendMessage(player, "messages.back", true);
            AFKManager.removeBossBar(player);
        }
    }

    private static void checkAFK() {
        if (config == null) {
            return;
        }
        long timeout = config.getLong("settings.timeout-seconds") * 1000L;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!lastActivity.containsKey(player.getUniqueId())) {
                lastActivity.put(player.getUniqueId(), System.currentTimeMillis());
                continue;
            }
            if (afkPlayers.contains(player.getUniqueId()) || System.currentTimeMillis() - lastActivity.get(player.getUniqueId()) < timeout) continue;
            AFKManager.setAFK(player, true);
        }
    }

    public static void setAFK(Player player, boolean afk) {
        if (afk) {
            String worldName;
            World world;
            afkPlayers.add(player.getUniqueId());
            AFKManager.sendMessage(player, "messages.afk", true);
            AFKManager.showBossBar(player);
            if (config.getBoolean("settings.kick-on-afk")) {
                player.kick(mm.deserialize(config.getString("messages.kick")));
            }
            if (config.getBoolean("settings.teleport.enabled") && (world = Bukkit.getWorld((String)(worldName = config.getString("settings.teleport.world")))) != null) {
                double x = config.getDouble("settings.teleport.x");
                double y = config.getDouble("settings.teleport.y");
                double z = config.getDouble("settings.teleport.z");
                player.teleport(new Location(world, x, y, z));
            }
            if (config.getBoolean("settings.sounds.enabled")) {
                player.playSound(player.getLocation(), Sound.valueOf((String)config.getString("settings.sounds.sound")), 1.0f, 1.0f);
            }
            if (config.getBoolean("settings.particles.enabled")) {
                player.getWorld().spawnParticle(Particle.valueOf((String)config.getString("settings.particles.particle")), player.getLocation(), 30, 0.5, 1.0, 0.5, 0.01);
            }
        } else {
            afkPlayers.remove(player.getUniqueId());
            AFKManager.sendMessage(player, "messages.back", true);
            AFKManager.removeBossBar(player);
        }
    }

    private static void sendMessage(Player player, String path, boolean broadcast) {
        String msg = config.getString(path);
        if (msg == null || msg.isEmpty()) {
            return;
        }
        Object component = mm.deserialize(msg.replace("%player%", player.getName()));
        if (broadcast && config.getBoolean("settings.broadcast.enabled")) {
            Bukkit.broadcast(component);
        } else {
            player.sendMessage(component);
        }
    }

    private static void showBossBar(Player player) {
        if (!config.getBoolean("settings.bossbar.enabled")) {
            return;
        }
        String text = config.getString("settings.bossbar.text").replace("%player%", player.getName());
        BossBar.Color color = BossBar.Color.valueOf(config.getString("settings.bossbar.color"));
        BossBar.Overlay overlay = BossBar.Overlay.valueOf(config.getString("settings.bossbar.style"));
        BossBar bossBar = BossBar.bossBar(mm.deserialize(text), 1.0f, color, overlay);
        bossBars.put(player.getUniqueId(), bossBar);
        player.showBossBar(bossBar);
    }

    private static void removeBossBar(Player player) {
        if (bossBars.containsKey(player.getUniqueId())) {
            player.hideBossBar(bossBars.get(player.getUniqueId()));
            bossBars.remove(player.getUniqueId());
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent e) {
        if (!e.getFrom().toVector().equals((Object)e.getTo().toVector())) {
            AFKManager.updateActivity(e.getPlayer());
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        lastActivity.remove(e.getPlayer().getUniqueId());
        afkPlayers.remove(e.getPlayer().getUniqueId());
        AFKManager.removeBossBar(e.getPlayer());
    }

    public static boolean isAFK(Player player) {
        return afkPlayers.contains(player.getUniqueId());
    }

    public static Set<String> getAFKPlayers() {
        HashSet<String> names = new HashSet<String>();
        for (UUID id : afkPlayers) {
            Player p = Bukkit.getPlayer((UUID)id);
            if (p == null) continue;
            names.add(p.getName());
        }
        return names;
    }

    static {
        lastActivity = new HashMap<UUID, Long>();
        afkPlayers = new HashSet<UUID>();
        bossBars = new HashMap<UUID, BossBar>();
        mm = MiniMessage.miniMessage();
    }
}

