/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.api;

import com.serveressentials.api.ServerEssentialsAPI;
import com.serveressentials.api.VaultAPI;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import net.lunark.io.vault.VaultManager;
import net.lunark.io.vault.VaultStorage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class APIImpl
implements ServerEssentialsAPI,
VaultAPI {
    private static volatile APIImpl instance;
    private static final Object LOCK;
    private final JavaPlugin plugin;
    private final VaultManager vaultManager;
    private final VaultStorage vaultStorage;
    private final ConcurrentHashMap<String, ReentrantLock> vaultLocks = new ConcurrentHashMap();

    private APIImpl(@NotNull JavaPlugin plugin, @NotNull VaultManager vaultManager, @NotNull VaultStorage vaultStorage) {
        this.plugin = plugin;
        this.vaultManager = vaultManager;
        this.vaultStorage = vaultStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(@NotNull JavaPlugin plugin, @NotNull VaultManager vaultManager, @NotNull VaultStorage vaultStorage) {
        Object object = LOCK;
        synchronized (object) {
            if (instance != null) {
                throw new IllegalStateException("APIImpl already initialized!");
            }
            instance = new APIImpl(plugin, vaultManager, vaultStorage);
            plugin.getLogger().info("ServerEssentialsAPI v2.0.7.1 initialized");
        }
    }

    @NotNull
    public static APIImpl getInstance() {
        APIImpl api = instance;
        if (api == null) {
            throw new IllegalStateException("ServerEssentials API is not loaded!");
        }
        return api;
    }

    @Override
    public boolean isAvailable() {
        return this.plugin.isEnabled();
    }

    @Override
    @NotNull
    public VaultAPI getVaults() {
        return this;
    }

    @Override
    public boolean openVault(@NotNull Player player, int vaultNumber) {
        if (!VaultAPI.isValidVaultNumber(vaultNumber)) {
            throw new IllegalArgumentException("Vault number must be 1-10");
        }
        String perm = "serveressentials.command.pv." + vaultNumber;
        if (player.hasPermission(perm)) {
            this.vaultManager.openVault(player, vaultNumber);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public CompletableFuture<Inventory> getVaultInventory(@NotNull UUID playerUUID, int vaultNumber) {
        if (!VaultAPI.isValidVaultNumber(vaultNumber)) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Invalid vault number: " + vaultNumber));
        }
        return this.vaultStorage.load(playerUUID, vaultNumber).thenApply(optData -> {
            Inventory inv = Bukkit.createInventory(null, (int)54, (String)("Vault #" + vaultNumber));
            if (optData.isPresent()) {
                this.vaultStorage.deserializeInto((String)optData.get(), inv);
            }
            return inv;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Void> saveVault(@NotNull UUID playerUUID, int vaultNumber, @NotNull Inventory inventory) {
        if (!VaultAPI.isValidVaultNumber(vaultNumber)) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Invalid vault number: " + vaultNumber));
        }
        return this.vaultStorage.save(playerUUID, vaultNumber, inventory);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> hasVault(@NotNull UUID playerUUID, int vaultNumber) {
        if (!VaultAPI.isValidVaultNumber(vaultNumber)) {
            return CompletableFuture.completedFuture(false);
        }
        return this.vaultStorage.exists(playerUUID, vaultNumber);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> clearVault(@NotNull UUID playerUUID, int vaultNumber) {
        if (!VaultAPI.isValidVaultNumber(vaultNumber)) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Invalid vault number: " + vaultNumber));
        }
        return this.vaultStorage.delete(playerUUID, vaultNumber);
    }

    @Override
    @NotNull
    public CompletableFuture<Integer> getVaultCount(@NotNull UUID playerUUID) {
        CompletableFuture[] futures = new CompletableFuture[10];
        for (int i = 0; i < 10; ++i) {
            futures[i] = this.hasVault(playerUUID, i + 1);
        }
        return CompletableFuture.allOf(futures).thenApply(v -> {
            int count = 0;
            for (CompletableFuture future : futures) {
                try {
                    if (!((Boolean)future.get()).booleanValue()) continue;
                    ++count;
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.WARNING, "[API] Error counting vaults for " + String.valueOf(playerUUID), e);
                }
            }
            return count;
        });
    }

    static {
        LOCK = new Object();
    }
}

