/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.AdminChatConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class AdminChatCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.adminchat";
    private static final String COMMAND_NAME = "adminchat";
    private static final Set<UUID> toggledCache = ConcurrentHashMap.newKeySet();
    private final PlayerLanguageManager langManager;
    private final AdminChatConfig config;
    private final CommandDataStorage dataStorage;

    public AdminChatCommand(PlayerLanguageManager langManager, AdminChatConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.adminchat.only-players", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.adminchat.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        UUID playerId = player.getUniqueId();
        if (args.length == 0) {
            if (toggledCache.contains(playerId)) {
                toggledCache.remove(playerId);
                this.dataStorage.deleteState(playerId, COMMAND_NAME, "enabled");
                player.sendMessage(this.langManager.getMessageFor(player, "commands.adminchat.toggle", "<green>Admin chat mode: {state}", LanguageManager.ComponentPlaceholder.of("{state}", "OFF")));
            } else {
                toggledCache.add(playerId);
                this.dataStorage.setState(playerId, COMMAND_NAME, "enabled", "true");
                player.sendMessage(this.langManager.getMessageFor(player, "commands.adminchat.toggle", "<green>Admin chat mode: {state}", LanguageManager.ComponentPlaceholder.of("{state}", "ON")));
            }
        } else {
            this.sendAdminMessage(player, String.join((CharSequence)" ", args));
        }
        return true;
    }

    private void sendAdminMessage(Player sender, String message) {
        Component formatted = this.langManager.getMessageFor(sender, "commands.adminchat.format", "<dark_gray>[<red>AdminChat<dark_gray>] <yellow>{player} <gray>\u00bb <white>{message}", LanguageManager.ComponentPlaceholder.of("{player}", sender.getName()), LanguageManager.ComponentPlaceholder.of("{message}", message));
        Bukkit.getOnlinePlayers().stream().filter(p -> p.hasPermission(PERMISSION)).forEach(p -> p.sendMessage(formatted));
        Bukkit.getConsoleSender().sendMessage(formatted);
    }

    public static boolean isInAdminChat(UUID playerId) {
        return toggledCache.contains(playerId);
    }

    public void loadPlayerState(UUID playerId) {
        this.dataStorage.getState(playerId, COMMAND_NAME, "enabled").thenAccept(opt -> {
            if (opt.isPresent() && "true".equals(opt.get())) {
                toggledCache.add(playerId);
            }
        });
    }

    public void unloadPlayerState(UUID playerId) {
        toggledCache.remove(playerId);
    }
}

