/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import net.lunark.io.commands.config.BalanceConfig;
import net.lunark.io.economy.ServerEssentialsEconomy;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class BalanceCommand
implements CommandExecutor {
    private static final String PERMISSION_SELF = "serveressentials.command.balance";
    private static final String PERMISSION_OTHERS = "serveressentials.command.balance.others";
    private static final String COMMAND_NAME = "balance";
    private final PlayerLanguageManager langManager;
    private final BalanceConfig config;
    private final ServerEssentialsEconomy economy;

    public BalanceCommand(PlayerLanguageManager langManager, BalanceConfig config, ServerEssentialsEconomy economy) {
        this.langManager = langManager;
        this.config = config;
        this.economy = economy;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player p;
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.langManager.getMessageFor(null, "commands.balance.only-player", "<red>Only players can check their own balance.", new LanguageManager.ComponentPlaceholder[0]).toString());
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission(PERMISSION_SELF)) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.balance.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_SELF)));
                return true;
            }
            double balance = this.economy.getBalance((OfflinePlayer)player);
            player.sendMessage(this.langManager.getMessageFor(player, "commands.balance.self", "<green>Your balance is: <gold>{balance}", LanguageManager.ComponentPlaceholder.of("{balance}", String.format("%.2f", balance))));
            return true;
        }
        if (!sender.hasPermission(PERMISSION_OTHERS)) {
            Player p2;
            sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (p2 = (Player)sender) : null, "commands.balance.no-permission-others", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_OTHERS)));
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
        if (target == null || !target.hasPlayedBefore() && !target.isOnline()) {
            Player p3;
            sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (p3 = (Player)sender) : null, "commands.balance.player-not-found", "<red>Player not found: <white>{player}", LanguageManager.ComponentPlaceholder.of("{player}", args[0])));
            return true;
        }
        double balance = this.economy.getBalance(target);
        sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (p = (Player)sender) : null, "commands.balance.other", "<green>{player}'s balance is: <gold>{balance}", LanguageManager.ComponentPlaceholder.of("{player}", target.getName()), LanguageManager.ComponentPlaceholder.of("{balance}", String.format("%.2f", balance))));
        return true;
    }
}

