/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.List;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.lunark.io.commands.config.BookConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public final class BookCommand
implements CommandExecutor {
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final BookConfig config;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final GsonComponentSerializer gsonSerializer = GsonComponentSerializer.gson();

    public BookCommand(Plugin plugin, PlayerLanguageManager langManager, BookConfig config) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "book.command.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("serveressentials.command.book")) {
            player.sendMessage(this.langManager.getMessageFor(player, "book.command.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", "serveressentials.command.book")));
            return true;
        }
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta meta = (BookMeta)book.getItemMeta();
        List pageStrings = this.plugin.getConfig().getStringList("book.pages");
        if (pageStrings.isEmpty()) {
            player.sendMessage(this.langManager.getMessageFor(player, "book.command.empty-pages", "<yellow>No book pages configured in config.yml!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        meta.setTitle(this.config.title);
        meta.setAuthor(this.config.author);
        for (String pageContent : pageStrings) {
            Object pageComponent = this.miniMessage.deserialize(pageContent);
            String jsonPage = (String)this.gsonSerializer.serialize(pageComponent);
            meta.addPage(new String[]{jsonPage});
        }
        book.setItemMeta((ItemMeta)meta);
        player.getInventory().addItem(new ItemStack[]{book});
        player.sendMessage(this.langManager.getMessageFor(player, "book.command.success", "<green>Book added to your inventory!", new LanguageManager.ComponentPlaceholder[0]));
        return true;
    }
}

