/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.UUID;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.BurnConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class BurnCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.burn";
    private static final String PERMISSION_OTHERS = "serveressentials.command.burn.others";
    private final PlayerLanguageManager langManager;
    private final BurnConfig config;
    private final CommandDataStorage dataStorage;

    public BurnCommand(PlayerLanguageManager langManager, BurnConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        UUID executorId;
        Player attacker;
        Player player;
        if (!sender.hasPermission(PERMISSION)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.burn.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)).toString());
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.burn.usage", "<red>Usage: <white>/burn <player> [seconds]", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null) {
            sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.burn.player-not-found", "<red>Player <yellow>{target}</yellow> not found!", LanguageManager.ComponentPlaceholder.of("{target}", args[0])).toString());
            return true;
        }
        if (sender instanceof Player && target.equals((Object)(player = (Player)sender))) {
            if (!player.hasPermission(PERMISSION)) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.burn.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
                return true;
            }
        } else if (!sender.hasPermission(PERMISSION_OTHERS)) {
            sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.burn.no-permission-sub", "<red>You need permission <yellow>{subpermission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{subpermission}", PERMISSION_OTHERS)).toString());
            return true;
        }
        if (target.getGameMode() == GameMode.CREATIVE || target.getGameMode() == GameMode.SPECTATOR) {
            sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.burn.immune-gamemode", "<red>{target} is in <yellow>{gamemode}</yellow> mode and is immune!", LanguageManager.ComponentPlaceholder.of("{target}", target.getName()), LanguageManager.ComponentPlaceholder.of("{gamemode}", target.getGameMode().name())).toString());
            return true;
        }
        int seconds = this.config.defaultDuration();
        if (args.length == 2) {
            try {
                seconds = Integer.parseInt(args[1]);
                if (seconds < 1 || seconds > this.config.maxDuration()) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.burn.invalid-number", "<red>Invalid! Use <yellow>1-{max}</yellow> seconds.", LanguageManager.ComponentPlaceholder.of("{max}", this.config.maxDuration())));
                return true;
            }
        }
        target.setFireTicks(seconds * 20);
        if (sender instanceof Player && target.equals((Object)(attacker = (Player)sender))) {
            target.sendMessage(this.langManager.getMessageFor(target, "commands.burn.self-burned", "<yellow>You set yourself on fire for <gold>{seconds} <yellow>seconds!", LanguageManager.ComponentPlaceholder.of("{seconds}", seconds)));
        } else {
            target.sendMessage(this.langManager.getMessageFor(target, "commands.burn.target-burned", "<red>You've been set on fire by <yellow>{attacker}</yellow>!", LanguageManager.ComponentPlaceholder.of("{attacker}", sender.getName())));
            sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.burn.sender-burned", "<yellow>{target}</yellow><red> is now burning for <yellow>{seconds}</yellow> seconds!", LanguageManager.ComponentPlaceholder.of("{target}", target.getName()), LanguageManager.ComponentPlaceholder.of("{seconds}", seconds)));
        }
        UUID uUID = executorId = sender instanceof Player ? ((Player)sender).getUniqueId() : null;
        if (executorId != null) {
            this.trackUsage(executorId, target.getUniqueId(), seconds, target.equals((Object)sender));
        }
        return true;
    }

    private void trackUsage(UUID executorId, UUID targetId, int seconds, boolean self) {
        this.dataStorage.getState(executorId, "burn", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(executorId, "burn", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(executorId, "burn", "last_target", targetId.toString());
            this.dataStorage.setState(executorId, "burn", "last_duration", String.valueOf(seconds));
            this.dataStorage.setState(executorId, "burn", "self_burn", String.valueOf(self));
        });
    }
}

