/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.lunark.io.commands.config.FreezeConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FreezeCommand
implements CommandExecutor,
Listener,
TabCompleter {
    private static final String PERMISSION = "serveressentials.command.freeze";
    private static final String PERMISSION_OTHERS = "serveressentials.freeze.command.others";
    private static final Set<UUID> FROZEN_PLAYERS = new HashSet<UUID>();
    private final PlayerLanguageManager langManager;
    private final Plugin plugin;

    public FreezeCommand(PlayerLanguageManager langManager, FreezeConfig config, Plugin plugin) {
        this.langManager = langManager;
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    public static Set<UUID> getFrozenPlayers() {
        return FROZEN_PLAYERS;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.freeze.only-player", "<red>Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.freeze.usage", "<red>Usage: /freeze <player>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.freeze.player-not-found", "<red>Player not found: <yellow>{player}</yellow>", LanguageManager.ComponentPlaceholder.of("{player}", args[0])));
            return true;
        }
        if (FROZEN_PLAYERS.contains(target.getUniqueId())) {
            FROZEN_PLAYERS.remove(target.getUniqueId());
            player.sendMessage(this.langManager.getMessageFor(player, "commands.freeze.unfroze", "<green>Unfroze <white>{player}</white>.", LanguageManager.ComponentPlaceholder.of("{player}", target.getName())));
            target.sendMessage(this.langManager.getMessageFor(target, "commands.freeze.target-unfrozen", "<green>You have been unfrozen.", new LanguageManager.ComponentPlaceholder[0]));
        } else {
            FROZEN_PLAYERS.add(target.getUniqueId());
            player.sendMessage(this.langManager.getMessageFor(player, "commands.freeze.froze", "<green>Froze <white>{player}</white>.", LanguageManager.ComponentPlaceholder.of("{player}", target.getName())));
            target.sendMessage(this.langManager.getMessageFor(target, "commands.freeze.target-frozen", "<red>You have been frozen!", new LanguageManager.ComponentPlaceholder[0]));
        }
        return true;
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (FROZEN_PLAYERS.contains(event.getPlayer().getUniqueId())) {
            event.getPlayer().sendMessage(this.langManager.getMessageFor(event.getPlayer(), "commands.freeze.target-frozen", "<red>You have been frozen!", new LanguageManager.ComponentPlaceholder[0]));
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (FROZEN_PLAYERS.contains(player.getUniqueId())) {
            if (player.isGliding() || player.getInventory().getItemInMainHand().getType() == Material.ENDER_PEARL) {
                return;
            }
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (FROZEN_PLAYERS.contains(player.getUniqueId())) {
            Material mat;
            Material material = mat = event.getItem() != null ? event.getItem().getType() : null;
            if (mat == Material.ENDER_PEARL) {
                return;
            }
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDrop(PlayerDropItemEvent event) {
        if (FROZEN_PLAYERS.contains(event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] strings) {
        return List.of();
    }
}

