/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.lunark.io.commands.config.InvseeConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public final class InvseeCommand
implements TabExecutor {
    private static final String PERMISSION = "serveressentials.command.invsee";
    private final PlayerLanguageManager langManager;
    private final InvseeConfig config;

    public InvseeCommand(PlayerLanguageManager langManager, InvseeConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.invsee.only-player", "<red>Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.invsee.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.invsee.usage", "<red>Usage: /invsee <player>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.invsee.player-not-found", "<red>Player not found: <yellow>{player}</yellow>", LanguageManager.ComponentPlaceholder.of("{player}", args[0])));
            return true;
        }
        player.openInventory((Inventory)target.getInventory());
        player.sendMessage(this.langManager.getMessageFor(player, "commands.invsee.success", "<green>Viewing <white>{player}</white>'s inventory.", LanguageManager.ComponentPlaceholder.of("{player}", target.getName())));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(input)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

