/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import net.kyori.adventure.text.Component;
import net.lunark.io.commands.config.KickAllConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class KickAllCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.kickall";
    private final PlayerLanguageManager langManager;
    private final KickAllConfig config;

    public KickAllCommand(PlayerLanguageManager langManager, KickAllConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission(PERMISSION)) {
            Player playerSender = sender instanceof Player ? (Player)sender : null;
            sender.sendMessage(this.langManager.getMessageFor(playerSender, "commands.kickall.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.kickall.usage", "<red>Usage: /kickall <reason>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        String reason = String.join((CharSequence)" ", args);
        int kickedCount = 0;
        Component kickMessage = this.langManager.getMessageFor(null, "commands.kickall.kick-message", "<red>You have been kicked by <yellow>{admin}</yellow>!\n<gray>Reason: <white>{reason}", LanguageManager.ComponentPlaceholder.of("{admin}", sender.getName()), LanguageManager.ComponentPlaceholder.of("{reason}", reason));
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p.equals((Object)sender)) continue;
            p.kick(kickMessage);
            ++kickedCount;
        }
        Component senderMessage = this.langManager.getMessageFor(null, "commands.kickall.sender-message", "<green>Successfully kicked <yellow>{count}</yellow> players.\n<gray>Reason: <white>{reason}", LanguageManager.ComponentPlaceholder.of("{count}", String.valueOf(kickedCount)), LanguageManager.ComponentPlaceholder.of("{reason}", reason));
        sender.sendMessage(senderMessage);
        return true;
    }
}

