/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.KittyCannonConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KittyCannonCommand
implements CommandExecutor,
TabCompleter {
    private static final String PERMISSION = "serveressentials.command.kittycannon";
    private final PlayerLanguageManager langManager;
    private final KittyCannonConfig config;
    private final CommandDataStorage dataStorage;

    public KittyCannonCommand(PlayerLanguageManager langManager, KittyCannonConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            Component message = this.langManager.getMessageFor(null, "commands.kittycannon.only-player", "<red>Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]);
            sender.sendMessage(message.toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            Component message = this.langManager.getMessageFor(player, "commands.kittycannon.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION));
            player.sendMessage(message);
            return true;
        }
        if (args.length > 1) {
            Component message = this.langManager.getMessageFor(player, "commands.kittycannon.usage", "<red>Usage: <white>/kittycannon [velocity]", new LanguageManager.ComponentPlaceholder[0]);
            player.sendMessage(message);
            return true;
        }
        double velocity = this.config.getVelocity();
        if (args.length == 1) {
            try {
                velocity = Double.parseDouble(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        LivingEntity kitty = (LivingEntity)player.getWorld().spawnEntity(player.getEyeLocation().add(player.getLocation().getDirection()), EntityType.CAT);
        Vector direction = player.getLocation().getDirection().multiply(velocity);
        kitty.setVelocity(direction);
        Component nameComponent = this.langManager.getMessageFor(player, "commands.kittycannon.name", "<light_purple>Kitty Cannon!", new LanguageManager.ComponentPlaceholder[0]);
        kitty.customName(nameComponent);
        kitty.setCustomNameVisible(true);
        Component message = this.langManager.getMessageFor(player, "commands.kittycannon.fired", "<green>Kitty cannon fired with velocity {velocity}!", LanguageManager.ComponentPlaceholder.of("{velocity}", String.valueOf(velocity)));
        player.sendMessage(message);
        this.trackUsage(player.getUniqueId(), "fired", 1);
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 1) {
            return List.of("1", "2", "3", "4", "5");
        }
        return List.of();
    }

    private void trackUsage(UUID playerId, String type, int value) {
        this.dataStorage.getState(playerId, "kittycannon", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "kittycannon", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "kittycannon", "last_type", type);
            this.dataStorage.setState(playerId, "kittycannon", "last_used", String.valueOf(System.currentTimeMillis()));
        });
    }
}

