/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.ArrayList;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.LoomConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public final class LoomCommand
implements CommandExecutor,
Listener {
    private static final String PERMISSION = "serveressentials.command.loom";
    private static final int GUI_SIZE = 27;
    private static final int CENTER_SLOT = 13;
    private final PlayerLanguageManager langManager;
    private final LoomConfig config;
    private final CommandDataStorage dataStorage;
    private final Plugin plugin;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final PlainTextComponentSerializer plainSerializer = PlainTextComponentSerializer.plainText();

    public LoomCommand(PlayerLanguageManager langManager, LoomConfig config, CommandDataStorage dataStorage, Plugin plugin) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
        this.plugin = plugin;
        if (plugin.getConfig().getBoolean("loom.enabled", true)) {
            Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.loom.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.loom.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        Component titleComponent = this.langManager.getMessageFor(player, "commands.loom.gui-title", "<red><bold>Loom Interface", new LanguageManager.ComponentPlaceholder[0]);
        String guiName = this.plainSerializer.serialize(titleComponent);
        Inventory loomGui = Bukkit.createInventory((InventoryHolder)player, (int)27, (String)guiName);
        ItemStack barrier = new ItemStack(Material.BARRIER);
        ItemMeta meta = barrier.getItemMeta();
        if (meta != null) {
            meta.displayName(this.langManager.getMessageFor(player, "commands.loom.error-item-name", "<red><bold>ERROR", new LanguageManager.ComponentPlaceholder[0]));
            ArrayList<Component> lore = new ArrayList<Component>();
            lore.add(this.langManager.getMessageFor(player, "commands.loom.error-item-lore", "<gray>Feature not yet implemented", new LanguageManager.ComponentPlaceholder[0]));
            meta.lore(lore);
            barrier.setItemMeta(meta);
        }
        loomGui.setItem(13, barrier);
        player.openInventory(loomGui);
        player.playSound(player.getLocation(), Sound.UI_LOOM_SELECT_PATTERN, 1.0f, 1.0f);
        player.sendMessage(this.langManager.getMessageFor(player, "commands.loom.opened", "<green>Loom interface opened!", new LanguageManager.ComponentPlaceholder[0]));
        UUID playerId = player.getUniqueId();
        this.dataStorage.getState(playerId, "loom", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "loom", "usage_count", String.valueOf(count + 1));
        });
        return true;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String expectedName;
        ItemStack item = event.getCurrentItem();
        if (item == null || item.getType() != Material.BARRIER) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.hasDisplayName()) {
            return;
        }
        String itemName = this.plainSerializer.serialize(meta.displayName());
        if (!itemName.equals(expectedName = this.plainSerializer.serialize(this.langManager.getMessageFor(event.getWhoClicked() instanceof Player ? (Player)event.getWhoClicked() : null, "commands.loom.error-item-name", "<red><bold>ERROR", new LanguageManager.ComponentPlaceholder[0])))) {
            return;
        }
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            player.sendMessage(this.langManager.getMessageFor(player, "commands.loom.clicked-error", "<red>You clicked the error item! Feature not implemented yet.", new LanguageManager.ComponentPlaceholder[0]));
        }
    }
}

