/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.time.Duration;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import net.lunark.io.commands.config.RebootConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class RebootCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.reboot";
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final RebootConfig config;

    public RebootCommand(Plugin plugin, PlayerLanguageManager langManager, RebootConfig config) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int minutes;
        Player player;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (!sender.hasPermission(PERMISSION)) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.reboot.no-permission", "<red>You do not have permission to use this command!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.reboot.usage", "<red>Usage: /reboot <minutes>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        try {
            minutes = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.reboot.usage", "<red>Usage: /reboot <minutes>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        final int seconds = minutes * 60;
        this.broadcastMessage("commands.reboot.announce-scheduled", minutes);
        new BukkitRunnable(){
            int remaining;
            {
                this.remaining = seconds;
            }

            public void run() {
                if (this.remaining == 0) {
                    RebootCommand.this.broadcastMessage("commands.reboot.announce-now", 0);
                    RebootCommand.this.broadcastTitle("commands.reboot.titles.now", 0, Duration.ofSeconds(2L));
                    RebootCommand.this.playEffects();
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"stop");
                    this.cancel();
                    return;
                }
                if (this.remaining == 3600 || this.remaining == 1800 || this.remaining == 600 || this.remaining == 300 || this.remaining == 60) {
                    int timeInMinutes = this.remaining / 60;
                    RebootCommand.this.broadcastMessage("commands.reboot.announce-minutes", timeInMinutes);
                    RebootCommand.this.broadcastTitle("commands.reboot.titles.minute-warning", timeInMinutes, Duration.ofSeconds(2L));
                }
                if (this.remaining <= 3 && this.remaining > 0) {
                    RebootCommand.this.broadcastMessage("commands.reboot.announce-seconds", this.remaining);
                    RebootCommand.this.broadcastTitle("commands.reboot.titles.second-warning", this.remaining, Duration.ofSeconds(2L));
                    RebootCommand.this.playEffects();
                }
                --this.remaining;
            }
        }.runTaskTimer(this.plugin, 0L, 20L);
        return true;
    }

    private void broadcastMessage(String key, int time) {
        Component message = this.langManager.getMessageFor(null, key, "<red>\u26a0 Server will reboot in {time} minute(s).", LanguageManager.ComponentPlaceholder.of("{time}", String.valueOf(time)));
        Bukkit.broadcast((Component)message);
    }

    private void broadcastTitle(String key, int time, Duration stay) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Component title = this.langManager.getMessageFor(player, key, "<yellow>\u23f3 Reboot in {time} minute(s).", LanguageManager.ComponentPlaceholder.of("{time}", String.valueOf(time)));
            player.showTitle(Title.title(title, Component.empty(), Title.Times.times(Duration.ofMillis(500L), stay, Duration.ofMillis(500L))));
        }
    }

    private void playEffects() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.playSound(player.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 1.0f, 1.0f);
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 2.0f);
            player.spawnParticle(Particle.FIREWORK, player.getLocation().add(0.0, 1.0, 0.0), 30, 0.5, 0.5, 0.5, 0.1);
        }
    }
}

