/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.concurrent.CompletableFuture;
import net.lunark.io.commands.config.ShopConfig;
import net.lunark.io.database.DatabaseManager;
import net.lunark.io.economy.ServerEssentialsEconomy;
import net.lunark.io.economy.ShopDataManager;
import net.lunark.io.economy.ShopGUIManager;
import net.lunark.io.economy.ShopStorage;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class ShopCommand
implements CommandExecutor {
    private static final String PERMISSION_USE = "serveressentials.command.shop";
    private static final String PERMISSION_RELOAD = "serveressentials.command.shop.reload";
    private static final String COMMAND_NAME = "shop";
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final ShopStorage storage;
    private final ShopConfig config;
    private final ShopGUIManager guiManager;
    private final ShopDataManager dataManager;

    public ShopCommand(Plugin plugin, PlayerLanguageManager langManager, DatabaseManager dbManager, ShopConfig config, ServerEssentialsEconomy economy) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.storage = new ShopStorage(plugin, dbManager);
        this.config = config;
        this.dataManager = new ShopDataManager(plugin, dbManager);
        this.guiManager = new ShopGUIManager(plugin, langManager, this.storage, config, economy, this.dataManager);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.shop.only-player", "<red>This command can only be used by players!", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION_USE)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.shop.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_USE)));
            return true;
        }
        if (args.length >= 1 && args[0].equalsIgnoreCase("reload")) {
            return this.handleReload(player, true);
        }
        this.guiManager.openMainGUI(player);
        return true;
    }

    private boolean handleReload(Player player, boolean forceFromFiles) {
        if (!player.hasPermission(PERMISSION_RELOAD)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.shop.no-permission-reload", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_RELOAD)));
            return true;
        }
        this.reloadShop(player, forceFromFiles).thenAccept(success -> {
            if (success.booleanValue()) {
                String message = forceFromFiles ? "<green>Shop reloaded from YML files and saved to database." : "<green>Shop reloaded from database.";
                player.sendMessage(this.langManager.getMessageFor(player, "economy.shop.reload-success", message, new LanguageManager.ComponentPlaceholder[0]));
            } else {
                player.sendMessage(this.langManager.getMessageFor(player, "economy.shop.reload-error", "<red>Error reloading shop configuration.", new LanguageManager.ComponentPlaceholder[0]));
            }
        });
        return true;
    }

    private CompletableFuture<Boolean> reloadShop(Player player, boolean forceFromFiles) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.plugin.getServer().getScheduler().runTask(this.plugin, () -> {
            try {
                this.guiManager.reloadConfigs(forceFromFiles);
                this.guiManager.refreshOpenInventories();
                future.complete(true);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to reload shop: " + e.getMessage());
                e.printStackTrace();
                future.complete(false);
            }
        });
        return future;
    }

    public ShopGUIManager getGuiManager() {
        return this.guiManager;
    }
}

