/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.ThunderConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThunderCommand
implements CommandExecutor,
TabCompleter {
    private static final String PERMISSION = "serveressentials.command.thunder";
    private static final String PERMISSION_OTHERS = "serveressentials.command.thunder.others";
    private final PlayerLanguageManager langManager;
    private final ThunderConfig config;
    private final CommandDataStorage dataStorage;

    public ThunderCommand(PlayerLanguageManager langManager, ThunderConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Player found;
        if (!(sender instanceof Player)) {
            Component message = this.langManager.getMessageFor(null, "commands.thunder.only-player", "Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]);
            sender.sendMessage(message.toString());
            return true;
        }
        Player player = (Player)sender;
        Player target = player;
        boolean isSelf = true;
        if (args.length > 0 && (found = Bukkit.getPlayerExact((String)args[0])) != null) {
            target = found;
            isSelf = false;
        }
        if (isSelf) {
            if (!player.hasPermission(PERMISSION)) {
                message = this.langManager.getMessageFor(player, "commands.thunder.no-permission", "You need permission {permission}!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION));
                player.sendMessage(message);
                return true;
            }
        } else if (!player.hasPermission(PERMISSION_OTHERS)) {
            message = this.langManager.getMessageFor(player, "commands.thunder.no-permission-others", "You need permission {permission}!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_OTHERS));
            player.sendMessage(message);
            return true;
        }
        Location loc = target.getLocation();
        target.getWorld().strikeLightningEffect(loc);
        String targetName = isSelf ? this.langManager.getMessageFor(player, "commands.thunder.self-name", "yourself", new LanguageManager.ComponentPlaceholder[0]).toString() : target.getName();
        Component message = this.langManager.getMessageFor(player, "commands.thunder.struck", "Thunder effect summoned at {target}!", LanguageManager.ComponentPlaceholder.of("{target}", targetName));
        player.sendMessage(message);
        this.trackUsage(player.getUniqueId(), isSelf ? "self" : "other", 1);
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 1) {
            String prefix = args[0].toLowerCase();
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(prefix)).collect(Collectors.toList());
        }
        return List.of();
    }

    private void trackUsage(UUID playerId, String type, int value) {
        this.dataStorage.getState(playerId, "thunder", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "thunder", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "thunder", "last_type", type);
            this.dataStorage.setState(playerId, "thunder", "last_used", String.valueOf(System.currentTimeMillis()));
        });
    }
}

