/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import net.lunark.io.commands.config.UptimeConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class UptimeCommand
implements CommandExecutor {
    private static final String PERMISSION = "serveressentials.command.uptime";
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final UptimeConfig config;
    private final long serverStartTime;

    public UptimeCommand(Plugin plugin, long serverStartTime, PlayerLanguageManager langManager, UptimeConfig config) {
        this.plugin = plugin;
        this.serverStartTime = serverStartTime;
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (!sender.hasPermission(PERMISSION)) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.uptime.no-permission", "<red>You do not have permission to use this command!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        long currentTime = System.currentTimeMillis();
        long uptimeMillis = currentTime - this.serverStartTime;
        long seconds = uptimeMillis / 1000L % 60L;
        long minutes = uptimeMillis / 60000L % 60L;
        long hours = uptimeMillis / 3600000L % 24L;
        long days = uptimeMillis / 86400000L;
        String uptimeStr = String.format("%d days, %d hours, %d minutes, %d seconds", days, hours, minutes, seconds);
        sender.sendMessage(this.langManager.getMessageFor(player, "commands.uptime.info", "<green>Server uptime: <white>{uptime}", LanguageManager.ComponentPlaceholder.of("{uptime}", uptimeStr)));
        return true;
    }
}

