/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import net.lunark.io.vault.VaultManager;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class VaultCommand
implements CommandExecutor {
    private final VaultManager vaultManager;
    private final PlayerLanguageManager langManager;

    public VaultCommand(VaultManager vaultManager, PlayerLanguageManager langManager) {
        this.vaultManager = vaultManager;
        this.langManager = langManager;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "vault.only-players", String.valueOf(ChatColor.RED) + "Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.vaultManager.openSelector(player);
            return true;
        }
        try {
            int vaultNumber = Integer.parseInt(args[0]);
            if (vaultNumber < 1 || vaultNumber > 10) {
                player.sendMessage(this.langManager.getMessageFor(player, "vault.invalid-number", String.valueOf(ChatColor.RED) + "Vault number must be between 1-10!", new LanguageManager.ComponentPlaceholder[0]));
                return true;
            }
            this.vaultManager.openVault(player, vaultNumber);
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.langManager.getMessageFor(player, "vault.invalid-number", String.valueOf(ChatColor.RED) + "Invalid vault number!", new LanguageManager.ComponentPlaceholder[0]));
        }
        return true;
    }
}

