/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.economy;

import net.lunark.io.economy.ShopGUIManager;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;

public class ShopGUIListener
implements Listener {
    private final ShopGUIManager guiManager;

    public ShopGUIListener(ShopGUIManager guiManager) {
        this.guiManager = guiManager;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (event.getClickedInventory() == null || event.getCurrentItem() == null) {
            return;
        }
        if (!this.guiManager.isShopGUIOpen(player.getUniqueId())) {
            return;
        }
        if (event.getClickedInventory() == event.getView().getTopInventory()) {
            event.setCancelled(true);
            this.guiManager.handleClick(player, event.getSlot(), event.getClick().name(), event.getInventory());
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        this.guiManager.cleanupPlayer(player.getUniqueId());
    }
}

