/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.homes;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.lunark.io.commands.config.HomesConfig;
import net.lunark.io.homes.Home;
import net.lunark.io.homes.HomeManager;
import net.lunark.io.homes.HomesConfirmHolder;
import net.lunark.io.homes.HomesMainHolder;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class HomeGUIListener
implements Listener {
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final HomesConfig config;
    private final HomeManager homeManager;
    private final Map<Player, PendingAction> pendingActions = new WeakHashMap<Player, PendingAction>();
    private final Map<Player, Integer> awaitingRename = new WeakHashMap<Player, Integer>();
    private static final Integer[] BED_SLOTS = new Integer[]{10, 12, 14, 16, 28, 30, 32, 34};
    private static final Integer[] DYE_SLOTS = new Integer[]{19, 21, 23, 25, 37, 39, 41, 43};
    private final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.legacySection();

    public HomeGUIListener(Plugin plugin, PlayerLanguageManager langManager, HomesConfig config, HomeManager homeManager) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.config = config;
        this.homeManager = homeManager;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        InventoryHolder i;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (event.getInventory().getHolder() instanceof HomesMainHolder) {
            int i2;
            event.setCancelled(true);
            int slot = event.getRawSlot();
            for (i2 = 0; i2 < BED_SLOTS.length; ++i2) {
                if (slot != BED_SLOTS[i2]) continue;
                this.handleBedClick(player, i2 + 1, event.getClick());
                return;
            }
            for (i2 = 0; i2 < DYE_SLOTS.length; ++i2) {
                if (slot != DYE_SLOTS[i2]) continue;
                this.handleDyeClick(player, i2 + 1);
                return;
            }
        }
        if ((i = event.getInventory().getHolder()) instanceof HomesConfirmHolder) {
            HomesConfirmHolder holder = (HomesConfirmHolder)i;
            event.setCancelled(true);
            PendingAction action = this.pendingActions.get(player);
            if (action == null) {
                player.closeInventory();
                return;
            }
            if (event.getRawSlot() == 10) {
                this.confirmAction(player, action);
            } else if (event.getRawSlot() == 16) {
                this.pendingActions.remove(player);
                this.openMainGUI(player);
            }
        }
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (!this.awaitingRename.containsKey(player)) {
            return;
        }
        event.setCancelled(true);
        int slot = this.awaitingRename.remove(player);
        String newName = event.getMessage().trim();
        this.homeManager.getHome(player.getUniqueId(), slot).thenAccept(opt -> {
            if (opt.isPresent()) {
                Home home = (Home)opt.get();
                home.setName(newName);
                this.homeManager.setHome(player.getUniqueId(), slot, home).thenAccept(v -> {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.rename.success", "<green>Home renamed to <yellow>{name}</yellow>!", LanguageManager.ComponentPlaceholder.of("{name}", newName)));
                    Bukkit.getScheduler().runTask(this.plugin, () -> this.openMainGUI(player));
                });
            }
        });
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.pendingActions.remove(player);
        this.awaitingRename.remove(player);
    }

    private void handleBedClick(Player player, int slot, ClickType clickType) {
        UUID uuid = player.getUniqueId();
        if (!this.canSetHome(player, slot)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.no-permission", "<red>You don't have permission to manage home {slot}!", LanguageManager.ComponentPlaceholder.of("{slot}", slot)));
            return;
        }
        this.homeManager.getHome(uuid, slot).thenAccept(opt -> {
            boolean hasHome = opt.isPresent();
            if (hasHome && clickType.isLeftClick()) {
                Bukkit.getScheduler().runTask(this.plugin, () -> {
                    Location loc = ((Home)opt.get()).toLocation();
                    if (loc != null) {
                        player.teleport(loc);
                    } else {
                        player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.world-missing", "<red>Home world is no longer available!", new LanguageManager.ComponentPlaceholder[0]));
                    }
                });
            } else if (!hasHome) {
                this.pendingActions.put(player, new PendingAction(Action.SET, slot));
                this.openConfirmGUI(player, slot, "set");
            } else if (this.config.allowRename && player.hasPermission("serveressentials.renamehome")) {
                this.pendingActions.put(player, new PendingAction(Action.RENAME, slot));
                this.openConfirmGUI(player, slot, "rename");
            }
        });
    }

    private void handleDyeClick(Player player, int slot) {
        UUID uuid = player.getUniqueId();
        if (!player.hasPermission("serveressentials.command.removehome")) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.no-permission-remove", "<red>You don't have permission to remove homes!", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        this.homeManager.getHome(uuid, slot).thenAccept(opt -> {
            if (opt.isEmpty()) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.empty-slot", "<gray>No home set in slot {slot}!", LanguageManager.ComponentPlaceholder.of("{slot}", slot)));
                return;
            }
            this.pendingActions.put(player, new PendingAction(Action.REMOVE, slot));
            this.openConfirmGUI(player, slot, "remove");
        });
    }

    private void confirmAction(Player player, PendingAction action) {
        UUID uuid = player.getUniqueId();
        switch (action.action.ordinal()) {
            case 0: {
                Home home = new Home("Home" + action.slot, player.getLocation());
                this.homeManager.setHome(uuid, action.slot, home).thenAccept(v -> player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.set.success", "<green>Home <yellow>{slot}</yellow> set!", LanguageManager.ComponentPlaceholder.of("{slot}", action.slot))));
                break;
            }
            case 1: {
                this.homeManager.removeHome(uuid, action.slot).thenAccept(v -> player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.remove.success", "<green>Home <yellow>{slot}</yellow> removed!", LanguageManager.ComponentPlaceholder.of("{slot}", action.slot))));
                break;
            }
            case 2: {
                this.awaitingRename.put(player, action.slot);
                player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.rename.prompt", "<yellow>Enter a new name for this home in chat:", new LanguageManager.ComponentPlaceholder[0]));
            }
        }
        this.pendingActions.remove(player);
        Bukkit.getScheduler().runTask(this.plugin, () -> this.openMainGUI(player));
    }

    public void openMainGUI(Player player) {
        this.getEmptyInventory(player, this.config.guiTitleMain, 54).thenAccept(inv -> {
            this.fillBackground((Inventory)inv);
            this.setupHomeSlots(player, (Inventory)inv);
            Bukkit.getScheduler().runTask(this.plugin, () -> player.openInventory(inv));
        });
    }

    public void openConfirmGUI(Player player, int slot, String mode) {
        String titleKey = "commands.homes.gui.titles.confirm";
        Component titleComponent = this.langManager.getMessageFor(null, titleKey, this.config.guiTitleConfirm, new LanguageManager.ComponentPlaceholder[0]);
        Bukkit.getScheduler().runTask(this.plugin, () -> {
            Inventory inv = Bukkit.createInventory((InventoryHolder)new HomesConfirmHolder(slot, mode), (int)27, (String)this.legacySerializer.serialize(titleComponent));
            ItemStack confirm = new ItemStack(Material.GREEN_STAINED_GLASS_PANE);
            ItemMeta confirmMeta = confirm.getItemMeta();
            Component confirmName = this.langManager.getMessageFor(player, "commands.homes.gui.confirm", "<green>Confirm", new LanguageManager.ComponentPlaceholder[0]);
            confirmMeta.setDisplayName(this.legacySerializer.serialize(confirmName));
            confirm.setItemMeta(confirmMeta);
            inv.setItem(10, confirm);
            ItemStack cancel = new ItemStack(Material.RED_STAINED_GLASS_PANE);
            ItemMeta cancelMeta = cancel.getItemMeta();
            Component cancelName = this.langManager.getMessageFor(player, "commands.homes.gui.cancel", "<red>Cancel", new LanguageManager.ComponentPlaceholder[0]);
            cancelMeta.setDisplayName(this.legacySerializer.serialize(cancelName));
            cancel.setItemMeta(cancelMeta);
            inv.setItem(16, cancel);
            ItemStack info = new ItemStack(Material.PAPER);
            ItemMeta infoMeta = info.getItemMeta();
            Component infoName = this.langManager.getMessageFor(player, "commands.homes.gui.info", "<white>Home {slot} - {mode}", LanguageManager.ComponentPlaceholder.of("{slot}", slot), LanguageManager.ComponentPlaceholder.of("{mode}", mode));
            infoMeta.setDisplayName(this.legacySerializer.serialize(infoName));
            inv.setItem(13, info);
            this.fillConfirmBackground(inv);
            player.openInventory(inv);
        });
    }

    private CompletableFuture<Inventory> getEmptyInventory(Player player, String titleKey, int size) {
        return CompletableFuture.supplyAsync(() -> {
            Component title = this.langManager.getMessageFor(null, titleKey, "Home GUI", new LanguageManager.ComponentPlaceholder[0]);
            return Bukkit.createInventory((InventoryHolder)new HomesMainHolder(), (int)size, (Component)title);
        });
    }

    private void setupHomeSlots(Player player, Inventory inv) {
        UUID uuid = player.getUniqueId();
        CompletableFuture.allOf(new CompletableFuture[]{this.homeManager.getAllHomes(uuid).thenAccept(homes -> Bukkit.getScheduler().runTask(this.plugin, () -> {
            for (int i = 0; i < Math.min(8, this.config.maxHomes); ++i) {
                int slot = i + 1;
                Home home = (Home)homes.get(slot);
                if (home != null) {
                    inv.setItem(BED_SLOTS[i].intValue(), this.createBedItem(player, slot, home, true));
                    inv.setItem(DYE_SLOTS[i].intValue(), this.createDyeItem(player, slot, true));
                    continue;
                }
                inv.setItem(BED_SLOTS[i].intValue(), this.createBedItem(player, slot, null, false));
                inv.setItem(DYE_SLOTS[i].intValue(), this.createDyeItem(player, slot, false));
            }
        }))});
    }

    private ItemStack createBedItem(Player player, int slot, Home home, boolean hasHome) {
        Material material = !this.canSetHome(player, slot) ? Material.RED_BED : (!hasHome ? Material.GRAY_BED : Material.BLUE_BED);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        Component nameComponent = this.langManager.getMessageFor(player, "commands.homes.gui.home-title", "<white>Home {slot}", LanguageManager.ComponentPlaceholder.of("{slot}", slot));
        meta.setDisplayName(this.legacySerializer.serialize(nameComponent));
        ArrayList<String> lore = new ArrayList<String>();
        if (!this.canSetHome(player, slot)) {
            Component noPerm = this.langManager.getMessageFor(player, "commands.homes.gui.no-permission", "<red>No Permission!", new LanguageManager.ComponentPlaceholder[0]);
            lore.add(this.legacySerializer.serialize(noPerm));
        } else if (!hasHome) {
            Component clickSet = this.langManager.getMessageFor(player, "commands.homes.gui.click-set", "<yellow>Click to set", new LanguageManager.ComponentPlaceholder[0]);
            lore.add(this.legacySerializer.serialize(clickSet));
        } else {
            Component nameLore = this.langManager.getMessageFor(player, "commands.homes.gui.name", "<gray>Name: <white><name>", LanguageManager.ComponentPlaceholder.of("<name>", home.getName()));
            lore.add(this.legacySerializer.serialize(nameLore));
            Component coords = this.langManager.getMessageFor(player, "commands.homes.gui.coords", "<gray>XYZ: <white>{x}, {y}, {z}", LanguageManager.ComponentPlaceholder.of("{x}", Math.round(home.getX())), LanguageManager.ComponentPlaceholder.of("{y}", Math.round(home.getY())), LanguageManager.ComponentPlaceholder.of("{z}", Math.round(home.getZ())));
            lore.add(this.legacySerializer.serialize(coords));
            Component teleport = this.langManager.getMessageFor(player, "commands.homes.gui.click-teleport", "<green>Left-click to teleport", new LanguageManager.ComponentPlaceholder[0]);
            lore.add(this.legacySerializer.serialize(teleport));
            Component manage = this.langManager.getMessageFor(player, "commands.homes.gui.click-manage", "<yellow>Right-click to manage", new LanguageManager.ComponentPlaceholder[0]);
            lore.add(this.legacySerializer.serialize(manage));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createDyeItem(Player player, int slot, boolean hasHome) {
        if (!player.hasPermission("serveressentials.command.removehome")) {
            ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
            ItemMeta meta = filler.getItemMeta();
            meta.setDisplayName("");
            filler.setItemMeta(meta);
            return filler;
        }
        Material material = !hasHome ? Material.GRAY_DYE : Material.LIME_DYE;
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        Component nameComponent = this.langManager.getMessageFor(player, "commands.homes.gui.manage-title", "<white>Manage Home {slot}", LanguageManager.ComponentPlaceholder.of("{slot}", slot));
        meta.setDisplayName(this.legacySerializer.serialize(nameComponent));
        ArrayList<String> lore = new ArrayList<String>();
        if (!hasHome) {
            Component empty = this.langManager.getMessageFor(player, "commands.homes.gui.empty", "<gray>Empty slot", new LanguageManager.ComponentPlaceholder[0]);
            lore.add(this.legacySerializer.serialize(empty));
        } else {
            Component remove = this.langManager.getMessageFor(player, "commands.homes.gui.click-remove", "<red>Click to remove", new LanguageManager.ComponentPlaceholder[0]);
            lore.add(this.legacySerializer.serialize(remove));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private void fillBackground(Inventory inv) {
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = filler.getItemMeta();
        meta.setDisplayName("");
        filler.setItemMeta(meta);
        for (int i = 0; i < inv.getSize(); ++i) {
            if (inv.getItem(i) != null) continue;
            inv.setItem(i, filler);
        }
    }

    private void fillConfirmBackground(Inventory inv) {
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = filler.getItemMeta();
        meta.setDisplayName("");
        filler.setItemMeta(meta);
        for (int i = 0; i < 27; ++i) {
            if (inv.getItem(i) != null) continue;
            inv.setItem(i, filler);
        }
    }

    private boolean canSetHome(Player player, int slot) {
        if (!player.hasPermission("serveressentials.command.sethome")) {
            return false;
        }
        if (player.hasPermission("serveressentials.command.sethome.*")) {
            return true;
        }
        return player.hasPermission("serveressentials.command.sethome." + slot);
    }

    private record PendingAction(Action action, int slot) {
    }

    private static enum Action {
        SET,
        REMOVE,
        RENAME;

    }
}

