/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.kit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.lunark.io.ServerEssentials;
import net.lunark.io.kit.KitManager;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class KitConfigManager {
    private static FileConfiguration config;
    private static File file;
    private static final String FILE_PATH = "kits/kits.yml";

    public static void setup(JavaPlugin plugin) {
        File folder = new File(plugin.getDataFolder(), "kits");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!(file = new File(plugin.getDataFolder(), FILE_PATH)).exists()) {
            plugin.saveResource(FILE_PATH, false);
        }
        config = YamlConfiguration.loadConfiguration((File)file);
        try (InputStream defStream = plugin.getResource(FILE_PATH);){
            if (defStream != null) {
                YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defStream, StandardCharsets.UTF_8));
                config.setDefaults((Configuration)defConfig);
                config.options().copyDefaults(true);
                KitConfigManager.save();
            }
        }
        catch (IOException e) {
            plugin.getLogger().severe("Failed to apply default kit config: " + e.getMessage());
        }
    }

    public static FileConfiguration getConfig() {
        return config;
    }

    public static void save() {
        try {
            config.save(file);
        }
        catch (IOException e) {
            ServerEssentials.getInstance().getLogger().severe("Could not save kits.yml: " + e.getMessage());
        }
    }

    public static void reload() {
        if (file == null) {
            file = new File(ServerEssentials.getInstance().getDataFolder(), FILE_PATH);
        }
        if (!file.exists()) {
            ServerEssentials.getInstance().saveResource(FILE_PATH, false);
        }
        config = YamlConfiguration.loadConfiguration((File)file);
        KitManager.loadKits(config);
    }
}

