/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.kit;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.kit.Kit;
import net.lunark.io.kit.KitConfig;
import net.lunark.io.kit.KitConfigManager;
import net.lunark.io.kit.KitManager;
import net.lunark.io.kit.KitPermission;
import net.lunark.io.kit.storage.KitStorage;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class KitGUIListener
implements Listener {
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final KitStorage kitStorage;
    private final KitConfig kitConfig;
    private static final String GUI_TITLE_KEY = "kits.gui.title";
    private static final String PREVIEW_TITLE_KEY = "kits.gui.preview-title";
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public KitGUIListener(Plugin plugin, PlayerLanguageManager langManager, KitStorage kitStorage, KitConfig kitConfig) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.kitStorage = kitStorage;
        this.kitConfig = kitConfig;
    }

    public void openKitGUI(Player player) {
        this.kitStorage.loadIntoCache(player.getUniqueId());
        Component title = this.langManager.getMessageFor(player, GUI_TITLE_KEY, this.kitConfig.getGuiTitle(), new LanguageManager.ComponentPlaceholder[0]);
        Inventory gui = Bukkit.createInventory(null, (int)this.kitConfig.getGuiSize(), (Component)title);
        ConfigurationSection kitsSec = KitConfigManager.getConfig().getConfigurationSection("kits");
        if (kitsSec == null) {
            player.sendMessage(this.langManager.getMessageFor(player, "kits.no-kits-defined", "<red>No kits are currently defined!", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        int slotIndex = 0;
        for (String kitId : kitsSec.getKeys(false)) {
            int slot;
            Kit kit = KitManager.getKit(kitId);
            if (kit == null) continue;
            boolean hasPermission = kit.getPermission() == null || kit.getPermission().isEmpty() || player.hasPermission(kit.getPermission());
            int n = slot = kit.getSlot() > 0 ? kit.getSlot() : slotIndex;
            if (slot >= gui.getSize()) {
                slot = slotIndex;
            }
            slotIndex = Math.max(slot + 1, slotIndex + 1);
            ItemStack icon = this.createKitIcon(kit, player, hasPermission);
            gui.setItem(slot, icon);
        }
        player.openInventory(gui);
    }

    private ItemStack createKitIcon(Kit kit, Player player, boolean hasPermission) {
        long remaining;
        ItemStack icon = new ItemStack(hasPermission ? kit.getDisplayMaterial() : Material.BARRIER);
        ItemMeta meta = icon.getItemMeta();
        if (meta == null) {
            return icon;
        }
        Object name = hasPermission ? this.miniMessage.deserialize(kit.getDisplayName()) : this.langManager.getMessageFor(player, "kits.locked-name", "<red>Locked: <gray>{kit}", LanguageManager.ComponentPlaceholder.of("{kit}", kit.getName()));
        meta.displayName(name);
        ArrayList<Object> lore = new ArrayList<Object>();
        for (String line : kit.getDisplayLore()) {
            lore.add(this.miniMessage.deserialize(line));
        }
        if (!hasPermission) {
            lore.add(this.langManager.getMessageFor(player, "kits.requires-permission", "<gray>Requires: <white>{permission}", LanguageManager.ComponentPlaceholder.of("{permission}", KitPermission.node(kit.getName()))));
        }
        if ((remaining = this.kitStorage.getRemainingCooldown(player.getUniqueId(), kit.getName(), KitConfigManager.getConfig().getInt("kits." + kit.getName() + ".cooldown", 0))) > 0L) {
            lore.add(this.langManager.getMessageFor(player, "kits.cooldown-info", "<gray>Cooldown: <red>{time}s", LanguageManager.ComponentPlaceholder.of("{time}", remaining)));
        }
        meta.lore(lore);
        NamespacedKey key = new NamespacedKey(this.plugin, "kit_id");
        meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)kit.getName());
        icon.setItemMeta(meta);
        return icon;
    }

    public void openKitPreview(Player player, String kitId) {
        Kit kit = KitManager.getKit(kitId);
        if (kit == null) {
            player.sendMessage(this.langManager.getMessageFor(player, "kits.kit-not-found", this.kitConfig.getKitNotFoundMessage(), LanguageManager.ComponentPlaceholder.of("{kit}", kitId)));
            return;
        }
        Component title = this.langManager.getMessageFor(player, PREVIEW_TITLE_KEY, this.kitConfig.getPreviewTitle(), LanguageManager.ComponentPlaceholder.of("{kit}", kitId));
        Inventory preview = Bukkit.createInventory(null, (int)54, (Component)title);
        List<ItemStack> items = kit.getItems();
        for (int i = 0; i < items.size() && i < 45; ++i) {
            preview.setItem(i, items.get(i));
        }
        ItemStack claimButton = this.createClaimButton(player, kitId);
        preview.setItem(53, claimButton);
        ItemStack backButton = this.createBackButton(player);
        preview.setItem(45, backButton);
        player.openInventory(preview);
    }

    private ItemStack createClaimButton(Player player, String kitId) {
        ItemStack item = new ItemStack(Material.LIME_CONCRETE);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        meta.displayName(this.langManager.getMessageFor(player, "kits.claim-button", "<green>\u2713 Claim Kit", new LanguageManager.ComponentPlaceholder[0]));
        int cooldown = KitConfigManager.getConfig().getInt("kits." + kitId + ".cooldown", 0);
        if (this.kitStorage.isOnCooldown(player.getUniqueId(), kitId, cooldown)) {
            item.setType(Material.RED_CONCRETE);
            meta.displayName(this.langManager.getMessageFor(player, "kits.cooldown-button", "<red>\u23f1 On Cooldown", new LanguageManager.ComponentPlaceholder[0]));
        }
        NamespacedKey key = new NamespacedKey(this.plugin, "kit_action");
        meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)("claim:" + kitId));
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createBackButton(Player player) {
        ItemStack item = new ItemStack(Material.BARRIER);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName(this.langManager.getMessageFor(player, "kits.back-button", "<red>\u2190 Back", new LanguageManager.ComponentPlaceholder[0]));
            NamespacedKey key = new NamespacedKey(this.plugin, "kit_action");
            meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)"back");
            item.setItemMeta(meta);
        }
        return item;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        boolean isPreviewGui;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String mainTitle = this.langManager.getMessageFor(player, GUI_TITLE_KEY, this.kitConfig.getGuiTitle(), new LanguageManager.ComponentPlaceholder[0]).toString();
        String previewTitle = this.langManager.getMessageFor(player, PREVIEW_TITLE_KEY, this.kitConfig.getPreviewTitle(), new LanguageManager.ComponentPlaceholder[0]).toString();
        String clickedTitle = event.getView().title().toString();
        boolean isMainGui = clickedTitle.equals(mainTitle);
        boolean bl = isPreviewGui = clickedTitle.contains("Preview Kit:") || clickedTitle.equals(previewTitle);
        if (!isMainGui && !isPreviewGui) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        NamespacedKey actionKey = new NamespacedKey(this.plugin, "kit_action");
        String action = (String)clicked.getItemMeta().getPersistentDataContainer().get(actionKey, PersistentDataType.STRING);
        if (action != null) {
            if (action.startsWith("claim:")) {
                String kitId = action.substring(6);
                this.claimKit(player, kitId);
                player.closeInventory();
            } else if (action.equals("back")) {
                this.openKitGUI(player);
            }
            return;
        }
        NamespacedKey kitKey = new NamespacedKey(this.plugin, "kit_id");
        String kitId = (String)clicked.getItemMeta().getPersistentDataContainer().get(kitKey, PersistentDataType.STRING);
        if (kitId != null) {
            this.openKitPreview(player, kitId);
        }
    }

    private void claimKit(Player player, String kitId) {
        Kit kit = KitManager.getKit(kitId);
        if (kit == null) {
            player.sendMessage(this.langManager.getMessageFor(player, "kits.kit-not-found", this.kitConfig.getKitNotFoundMessage(), LanguageManager.ComponentPlaceholder.of("{kit}", kitId)));
            return;
        }
        if (!player.hasPermission(KitPermission.node(kitId))) {
            player.sendMessage(this.langManager.getMessageFor(player, "kits.no-permission", this.kitConfig.getNoPermissionMessage(), LanguageManager.ComponentPlaceholder.of("{kit}", kitId), LanguageManager.ComponentPlaceholder.of("{permission}", KitPermission.node(kitId))));
            return;
        }
        int cooldown = KitConfigManager.getConfig().getInt("kits." + kitId + ".cooldown", 0);
        if (this.kitStorage.isOnCooldown(player.getUniqueId(), kitId, cooldown)) {
            long remaining = this.kitStorage.getRemainingCooldown(player.getUniqueId(), kitId, cooldown);
            player.sendMessage(this.langManager.getMessageFor(player, "kits.cooldown", this.kitConfig.getCooldownMessage(), LanguageManager.ComponentPlaceholder.of("{kit}", kitId), LanguageManager.ComponentPlaceholder.of("{time}", remaining)));
            return;
        }
        for (ItemStack item : kit.getItems()) {
            if (item == null) continue;
            player.getInventory().addItem(new ItemStack[]{item});
        }
        this.kitStorage.saveKitClaim(player.getUniqueId(), kitId);
        player.sendMessage(this.langManager.getMessageFor(player, "kits.claim-success", this.kitConfig.getClaimSuccessMessage(), LanguageManager.ComponentPlaceholder.of("{kit}", kitId)));
    }
}

