/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.listeners;

import net.lunark.io.commands.impl.GodCommand;
import net.lunark.io.commands.impl.VanishCommand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class AdminUtilitiesListener
implements Listener {
    private final Plugin plugin;
    private final GodCommand godCommand;
    private final VanishCommand vanishCommand;

    public AdminUtilitiesListener(Plugin plugin, GodCommand godCommand, VanishCommand vanishCommand) {
        this.plugin = plugin;
        this.godCommand = godCommand;
        this.vanishCommand = vanishCommand;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.godCommand.loadPlayerState(player.getUniqueId());
        this.vanishCommand.loadPlayerState(player.getUniqueId());
        this.plugin.getServer().getScheduler().runTaskLater(this.plugin, () -> {
            if (VanishCommand.isVanished(player.getUniqueId())) {
                this.plugin.getServer().getOnlinePlayers().forEach(p -> p.hidePlayer(this.plugin, player));
            }
        }, 10L);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.godCommand.unloadPlayerState(event.getPlayer().getUniqueId());
        this.vanishCommand.unloadPlayerState(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && this.godCommand.isGodMode((player = (Player)entity).getUniqueId())) {
            event.setCancelled(true);
        }
    }
}

