/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.lobby;

import net.lunark.io.commands.config.LobbyConfig;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AnimationHelper {
    public static void playTeleportAnimation(Plugin plugin, Player player, LobbyConfig.AnimationOptions options) {
        if (options == null) {
            return;
        }
        Location loc = player.getLocation();
        if (options.sound != null) {
            player.playSound(loc, options.sound, 1.0f, 1.0f);
        }
        switch (options.type.toUpperCase()) {
            case "FADE": {
                AnimationHelper.playFadeAnimation(plugin, player, options);
                break;
            }
            case "PARTICLE": {
                AnimationHelper.playParticleAnimation(plugin, loc, options);
                break;
            }
            case "BOTH": {
                AnimationHelper.playFadeAnimation(plugin, player, options);
                AnimationHelper.playParticleAnimation(plugin, loc, options);
            }
        }
    }

    private static void playFadeAnimation(Plugin plugin, Player player, LobbyConfig.AnimationOptions options) {
        player.sendTitle("\u00a7aTeleporting...", "", 10, options.duration, 20);
        Bukkit.getScheduler().runTaskLater(plugin, () -> {}, 5L);
    }

    private static void playParticleAnimation(Plugin plugin, Location loc, LobbyConfig.AnimationOptions options) {
        for (int i = 0; i < options.particleCount; ++i) {
            double offsetX = (Math.random() - 0.5) * 2.0;
            double offsetY = Math.random() * 2.0;
            double offsetZ = (Math.random() - 0.5) * 2.0;
            loc.getWorld().spawnParticle(options.particle, loc.clone().add(offsetX, offsetY, offsetZ), 0, 0.0, 0.0, 0.0, 1.0);
        }
    }
}

