/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.mail;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import net.lunark.io.mail.MailConfig;
import net.lunark.io.mail.MailStorage;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MailListener
implements Listener {
    private final MailStorage storage;
    private final PlayerLanguageManager langManager;
    private final MailConfig config;
    private final JavaPlugin plugin;
    private final Set<UUID> notifiedPlayers = ConcurrentHashMap.newKeySet();

    public MailListener(MailStorage storage, PlayerLanguageManager langManager, MailConfig config, JavaPlugin plugin) {
        this.storage = storage;
        this.langManager = langManager;
        this.config = config;
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        final Player player = event.getPlayer();
        final UUID playerId = player.getUniqueId();
        new BukkitRunnable(){

            public void run() {
                MailListener.this.storage.getUnreadCount(playerId).thenAccept(count -> {
                    if (count > 0 && MailListener.this.notifiedPlayers.add(playerId)) {
                        Component msg = MailListener.this.langManager.getMessageFor(player, "mail.on-join", "<gold>You have <yellow>{count}</yellow> unread mails! Use <white>/mail read</white>", LanguageManager.ComponentPlaceholder.of("{count}", String.valueOf(count)));
                        player.sendMessage(msg);
                    }
                });
            }
        }.runTaskLater((Plugin)this.plugin, (long)this.config.joinNotifyDelay);
    }

    public void resetNotification(UUID playerId) {
        this.notifiedPlayers.remove(playerId);
    }
}

