/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.reports;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.lunark.io.database.DatabaseManager;
import net.lunark.io.reports.Report;
import org.bukkit.plugin.Plugin;

public class ReportStorage {
    private final DatabaseManager dbManager;
    private final String poolKey = "reports";
    private final Plugin plugin;

    public ReportStorage(Plugin plugin, DatabaseManager dbManager) {
        this.dbManager = dbManager;
        this.plugin = plugin;
        this.initTable();
    }

    private void initTable() {
        String tableSql = "CREATE TABLE IF NOT EXISTS reports (id TEXT PRIMARY KEY, reporter_uuid TEXT NOT NULL, target_uuid TEXT NOT NULL, reason TEXT NOT NULL, timestamp BIGINT NOT NULL, pending BOOLEAN DEFAULT TRUE)";
        ((CompletableFuture)this.dbManager.executeUpdate("reports", tableSql, new Object[0]).thenRun(() -> {
            String indexSql = "CREATE INDEX IF NOT EXISTS idx_pending ON reports(pending)";
            this.dbManager.executeUpdate("reports", indexSql, new Object[0]).exceptionally(ex -> {
                this.plugin.getLogger().warning("Failed to create reports index: " + ex.getMessage());
                return null;
            });
            String cooldownTableSql = "CREATE TABLE IF NOT EXISTS report_cooldowns (player_uuid TEXT PRIMARY KEY, timestamp BIGINT)";
            this.dbManager.executeUpdate("reports", cooldownTableSql, new Object[0]).exceptionally(ex -> {
                this.plugin.getLogger().warning("Failed to create report cooldown table: " + ex.getMessage());
                return null;
            });
        })).exceptionally(ex -> {
            this.plugin.getLogger().severe("Failed to create reports table: " + ex.getMessage());
            return null;
        });
    }

    public CompletableFuture<Void> addReport(Report report) {
        String sql = "INSERT INTO reports (id, reporter_uuid, target_uuid, reason, timestamp, pending) VALUES (?, ?, ?, ?, ?, ?)";
        return this.dbManager.executeUpdate("reports", sql, report.id(), report.reporterId().toString(), report.targetId().toString(), report.reason(), report.timestamp(), report.pending());
    }

    public CompletableFuture<Optional<Report>> getReport(String id) {
        String sql = "SELECT * FROM reports WHERE id = ?";
        return this.dbManager.executeQuery("reports", sql, this::mapReport, id);
    }

    public CompletableFuture<List<Report>> getAllReports() {
        String sql = "SELECT * FROM reports ORDER BY timestamp DESC";
        return this.dbManager.executeQuery("reports", sql, rs -> {
            ArrayList<Report> reports = new ArrayList<Report>();
            while (rs.next()) {
                reports.add(this.mapReport(rs));
            }
            return reports;
        }, new Object[0]).thenApply(opt -> opt.orElse(new ArrayList()));
    }

    public CompletableFuture<List<Report>> getPendingReports() {
        String sql = "SELECT * FROM reports WHERE pending = TRUE ORDER BY timestamp DESC";
        return this.dbManager.executeQuery("reports", sql, rs -> {
            ArrayList<Report> reports = new ArrayList<Report>();
            while (rs.next()) {
                reports.add(this.mapReport(rs));
            }
            return reports;
        }, new Object[0]).thenApply(opt -> opt.orElse(new ArrayList()));
    }

    public CompletableFuture<Void> clearReport(String id) {
        String sql = "DELETE FROM reports WHERE id = ?";
        return this.dbManager.executeUpdate("reports", sql, id);
    }

    public CompletableFuture<Void> markAsCleared(String id) {
        String sql = "UPDATE reports SET pending = FALSE WHERE id = ?";
        return this.dbManager.executeUpdate("reports", sql, id);
    }

    private Report mapReport(ResultSet rs) throws SQLException {
        return new Report(rs.getString("id"), UUID.fromString(rs.getString("reporter_uuid")), UUID.fromString(rs.getString("target_uuid")), rs.getString("reason"), rs.getLong("timestamp"), rs.getBoolean("pending"));
    }

    public CompletableFuture<Void> saveCooldown(UUID playerId, long timestamp) {
        String sql = "INSERT OR REPLACE INTO report_cooldowns (player_uuid, timestamp) VALUES (?, ?)";
        return this.dbManager.executeUpdate("reports", sql, playerId.toString(), timestamp);
    }

    public CompletableFuture<Long> getCooldown(UUID playerId) {
        String sql = "SELECT timestamp FROM report_cooldowns WHERE player_uuid = ?";
        return this.dbManager.executeQuery("reports", sql, rs -> rs.next() ? rs.getLong("timestamp") : 0L, playerId.toString()).thenApply(opt -> opt.orElse(0L));
    }
}

