/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.vault;

import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.lunark.io.ServerEssentials;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import net.lunark.io.vault.VaultStorage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class VaultManager {
    private final ServerEssentials plugin;
    private final PlayerLanguageManager langManager;
    private final VaultStorage storage;
    private static final int MAX_VAULTS = 10;

    public VaultManager(ServerEssentials plugin, PlayerLanguageManager langManager, VaultStorage storage) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.storage = storage;
    }

    public void openVault(Player player, int number) {
        if (!this.isValidVaultNumber(number)) {
            player.sendMessage(this.getMessage(player, "vault.invalid", Component.text("Invalid vault number! Must be 1-10", (TextColor)NamedTextColor.RED)));
            return;
        }
        if (!this.hasVaultPermission(player, number)) {
            Component msg = this.getMessage(player, "vault.no-permission", Component.text("You need permission: serveressentials.command.pv.", (TextColor)NamedTextColor.RED).append(Component.text(number, (TextColor)NamedTextColor.YELLOW)));
            player.sendMessage(msg);
            return;
        }
        Component title = this.getMessage(player, "vault.title", Component.text("Vault #", (TextColor)NamedTextColor.GREEN).append(Component.text(number, (TextColor)NamedTextColor.WHITE)));
        Inventory inv = Bukkit.createInventory(null, (int)54, (Component)title);
        this.storage.load(player.getUniqueId(), number).thenAccept(optData -> {
            if (optData.isPresent()) {
                this.storage.deserializeInto((String)optData.get(), inv);
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                player.openInventory(inv);
                player.setMetadata("vault_id", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)number));
            });
        });
    }

    public void openSelector(Player player) {
        Component title = this.getMessage(player, "vault.selector.title", Component.text("Select a Vault", (TextColor)NamedTextColor.YELLOW));
        Inventory gui = Bukkit.createInventory(null, (int)45, (Component)title);
        int[] slots = new int[]{10, 12, 14, 16, 19, 21, 23, 25, 28, 30};
        for (int i = 0; i < 10; ++i) {
            gui.setItem(slots[i], this.createVaultIcon(player, i + 1));
        }
        ItemStack close = new ItemStack(Material.BARRIER);
        ItemMeta meta = close.getItemMeta();
        meta.displayName(this.getMessage(player, "vault.selector.close", Component.text("Close", (TextColor)NamedTextColor.RED)));
        close.setItemMeta(meta);
        gui.setItem(40, close);
        player.openInventory(gui);
    }

    private ItemStack createVaultIcon(Player player, int number) {
        boolean hasPerm = this.hasVaultPermission(player, number);
        Material mat = hasPerm ? Material.BARREL : Material.BARRIER;
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        Component name = hasPerm ? this.getMessage(player, "vault.selector.unlocked", Component.text("Vault #", (TextColor)NamedTextColor.GREEN).append(Component.text(number, (TextColor)NamedTextColor.WHITE))) : this.getMessage(player, "vault.selector.locked", ((TextComponent)Component.text("Vault #", (TextColor)NamedTextColor.RED).append(Component.text(number, (TextColor)NamedTextColor.WHITE))).append(Component.text(" \ud83d\udd12", (TextColor)NamedTextColor.RED)));
        meta.displayName(name);
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(this.getMessage(player, hasPerm ? "vault.selector.open" : "vault.selector.no-perm", Component.text(hasPerm ? "Click to open" : "No permission", (TextColor)NamedTextColor.GRAY)));
        meta.lore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public void onVaultClose(Player player, Inventory inv) {
        if (player.hasMetadata("vault_id")) {
            int vaultId = ((MetadataValue)player.getMetadata("vault_id").get(0)).asInt();
            player.removeMetadata("vault_id", (Plugin)this.plugin);
            this.storage.save(player.getUniqueId(), vaultId, inv).thenAccept(v -> player.sendMessage(this.getMessage(player, "vault.saved", ((TextComponent)Component.text("Vault ", (TextColor)NamedTextColor.GREEN).append(Component.text(vaultId, (TextColor)NamedTextColor.YELLOW))).append(Component.text(" saved!", (TextColor)NamedTextColor.GREEN)))));
        }
    }

    private boolean isValidVaultNumber(int number) {
        return number >= 1 && number <= 10;
    }

    private boolean hasVaultPermission(Player player, int number) {
        return player.hasPermission("serveressentials.command.pv." + number);
    }

    private Component getMessage(Player player, String key, Component fallback) {
        return this.langManager.getMessageFor(player, key, String.valueOf(fallback), new LanguageManager.ComponentPlaceholder[0]);
    }
}

