/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.vault;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import net.lunark.io.vault.VaultManager;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class VaultSelectorListener
implements Listener {
    private final VaultManager vaultManager;
    private final PlayerLanguageManager langManager;
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+");

    public VaultSelectorListener(VaultManager vaultManager, PlayerLanguageManager langManager) {
        this.vaultManager = vaultManager;
        this.langManager = langManager;
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        String actualTitle;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (event.getView().getTopInventory().getSize() != 45) {
            return;
        }
        String expectedTitle = PlainTextComponentSerializer.plainText().serialize(this.langManager.getMessageFor(player, "vault.selector.title", "Select a Vault", new LanguageManager.ComponentPlaceholder[0]));
        if (!expectedTitle.equalsIgnoreCase(actualTitle = PlainTextComponentSerializer.plainText().serialize(event.getView().title()))) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        if (clicked.getType() == Material.BARRIER) {
            player.closeInventory();
            return;
        }
        if (clicked.getType() != Material.BARREL) {
            return;
        }
        String plainName = PlainTextComponentSerializer.plainText().serialize(clicked.getItemMeta().displayName());
        Matcher matcher = NUMBER_PATTERN.matcher(plainName);
        if (!matcher.find()) {
            return;
        }
        int vaultNumber = Integer.parseInt(matcher.group());
        String perm = "serveressentials.command.pv." + vaultNumber;
        if (player.hasPermission(perm)) {
            player.closeInventory();
            this.vaultManager.openVault(player, vaultNumber);
        }
    }
}

