/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Managers;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class ModuleManager {
    private final Plugin plugin;
    private final Map<String, Boolean> modules = new HashMap<String, Boolean>();

    public ModuleManager(Plugin plugin) {
        this.plugin = plugin;
    }

    public void loadFromConfig(FileConfiguration cfg) {
        if (cfg.getConfigurationSection("modules") == null) {
            return;
        }
        for (String key : cfg.getConfigurationSection("modules").getKeys(false)) {
            this.modules.put(key.toLowerCase(), cfg.getBoolean("modules." + key + ".enabled", true));
        }
    }

    public boolean isEnabled(String moduleKey) {
        return this.modules.getOrDefault(moduleKey.toLowerCase(), true);
    }

    public void setEnabled(String moduleKey, boolean enabled) {
        this.modules.put(moduleKey.toLowerCase(), enabled);
    }

    public Map<String, Boolean> snapshot() {
        return new HashMap<String, Boolean>(this.modules);
    }
}

