/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Managers;

import java.io.File;
import net.lunark.io.Managers.AFKManager;
import net.lunark.io.ServerEssentials;
import net.lunark.io.kit.KitConfigManager;
import net.lunark.io.nick.NickManager;
import net.lunark.io.util.ReloadUtils;
import net.lunark.io.util.WarpMessages;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public class ReloadManager {
    private static ReloadManager instance;
    private final ServerEssentials plugin;

    public ReloadManager(ServerEssentials plugin) {
        this.plugin = plugin;
        instance = this;
    }

    public static ReloadManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException("ReloadManager has not been initialized yet!");
        }
        return instance;
    }

    public static void reloadAll(CommandSender sender) {
        ReloadManager.getInstance().reloadEverything(sender);
    }

    public void reloadEverything(CommandSender sender) {
        long start = System.currentTimeMillis();
        File dataFolder = this.plugin.getDataFolder();
        this.plugin.getLanguageManager().reloadLanguages();
        this.plugin.reloadConfig();
        KitConfigManager.reload();
        NickManager.reload();
        WarpMessages.fullReload();
        AFKManager.reload();
        ReloadUtils.reloadAllInDirectory(new File(dataFolder, "config"));
        ReloadUtils.reloadAllInDirectory(new File(dataFolder, "messages"));
        ReloadUtils.reloadAllInDirectory(new File(dataFolder, "shop"));
        ReloadUtils.reloadAllInDirectory(new File(dataFolder, "storage"));
        for (String rootFile : new String[]{"Config.yml", "FJ.yml", "kits.yml", "placeholders.yml"}) {
            File file = new File(dataFolder, rootFile);
            if (!file.exists()) continue;
            ReloadUtils.reloadFile(file);
        }
        long elapsed = System.currentTimeMillis() - start;
        Bukkit.getLogger().info("[ServerEssentials] Reloaded all files in " + elapsed + "ms.");
    }
}

