/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Rtp;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class RtpConfig {
    private final Plugin plugin;
    private final FileConfiguration config;
    private final Map<String, WorldConfig> worldConfigs = new HashMap<String, WorldConfig>();

    public RtpConfig(Plugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        this.load();
    }

    public void reload() {
        this.plugin.reloadConfig();
    }

    public void load() {
        this.worldConfigs.clear();
        if (!this.config.contains("rtp")) {
            this.config.createSection("rtp");
            this.config.set("rtp.example_world.enabled", (Object)true);
            this.config.set("rtp.example_world.min_radius", (Object)1000);
            this.config.set("rtp.example_world.max_radius", (Object)5000);
            this.config.set("rtp.example_world.cooldown_seconds", (Object)300);
            this.plugin.saveConfig();
        }
        for (String worldName : this.config.getConfigurationSection("rtp").getKeys(false)) {
            String path = "rtp." + worldName + ".";
            boolean enabled = this.config.getBoolean(path + "enabled", false);
            int min = this.config.getInt(path + "min_radius", 1000);
            int max = this.config.getInt(path + "max_radius", 5000);
            int cooldown = this.config.getInt(path + "cooldown_seconds", 300);
            this.worldConfigs.put(worldName, new WorldConfig(enabled, min, max, cooldown));
        }
    }

    public boolean isWorldEnabled(String worldName) {
        return this.worldConfigs.getOrDefault(worldName, new WorldConfig(false, 0, 0, 0)).enabled();
    }

    public int getMinRadius(String worldName) {
        return this.worldConfigs.getOrDefault(worldName, new WorldConfig(false, 1000, 5000, 300)).minRadius();
    }

    public int getMaxRadius(String worldName) {
        return this.worldConfigs.getOrDefault(worldName, new WorldConfig(false, 1000, 5000, 300)).maxRadius();
    }

    public int getCooldown(String worldName) {
        return this.worldConfigs.getOrDefault(worldName, new WorldConfig(false, 1000, 5000, 300)).cooldown();
    }

    public record WorldConfig(boolean enabled, int minRadius, int maxRadius, int cooldown) {
    }
}

