/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.TPA;

import java.util.List;
import org.bukkit.plugin.Plugin;

public class TPAConfig {
    private final Plugin plugin;
    public final int cooldown;
    public final int timeout;
    public final int warmup;
    public final int teleportDelay;
    public final boolean cancelOnMove;
    public final boolean blockMoveThresholdBlocks;
    public final boolean chatEnabled;
    public final boolean actionbarEnabled;
    public final boolean bossbarEnabled;
    public final String bossbarColor;
    public final String bossbarStyle;
    public final int bossbarDuration;
    public final boolean titleEnabled;
    public final boolean crossWorld;
    public final List<String> blockedWorlds;
    public final boolean economyEnabled;
    public final double costTpa;
    public final double costTpahere;
    public final double costTpall;
    public final boolean refundOnDeny;
    public final boolean refundOnExpire;
    public final boolean particlesEnabled;
    public final String particleType;
    public final String soundRequest;
    public final String soundAccept;
    public final String soundDeny;
    public final String soundTeleport;

    public TPAConfig(Plugin plugin) {
        this.plugin = plugin;
        this.cooldown = this.getInt("settings.cooldown", 5);
        this.timeout = this.getInt("settings.timeout", 60);
        this.warmup = this.getInt("settings.warmup", 0);
        this.teleportDelay = this.getInt("teleport-delay", 3);
        this.cancelOnMove = this.getBool("settings.cancel-on-move", true);
        this.blockMoveThresholdBlocks = this.getBool("settings.block-move-threshold-blocks", true);
        this.chatEnabled = this.getBool("notifications.chat", true);
        this.actionbarEnabled = this.getBool("notifications.actionbar", false);
        this.bossbarEnabled = this.getBool("notifications.bossbar", false);
        this.bossbarColor = plugin.getConfig().getString("tpa.notifications.bossbar-color", "BLUE");
        this.bossbarStyle = plugin.getConfig().getString("tpa.notifications.bossbar-style", "SOLID");
        this.bossbarDuration = Math.max(1, this.getInt("notifications.bossbar-duration", 5));
        this.titleEnabled = this.getBool("notifications.title", false);
        this.crossWorld = this.getBool("restrictions.cross-world", false);
        this.blockedWorlds = plugin.getConfig().getStringList("tpa.restrictions.blocked-worlds");
        this.economyEnabled = this.getBool("economy.enabled", false);
        this.costTpa = this.getDouble("economy.cost.tpa", 0.0);
        this.costTpahere = this.getDouble("economy.cost.tpahere", 0.0);
        this.costTpall = this.getDouble("economy.cost.tpall", 0.0);
        this.refundOnDeny = this.getBool("economy.refund-on-deny", true);
        this.refundOnExpire = this.getBool("economy.refund-on-expire", true);
        this.particlesEnabled = this.getBool("particles.enabled", true);
        this.particleType = plugin.getConfig().getString("tpa.particles.type", "PORTAL");
        this.soundRequest = plugin.getConfig().getString("tpa.sounds.request", "ENTITY_EXPERIENCE_ORB_PICKUP");
        this.soundAccept = plugin.getConfig().getString("tpa.sounds.accept", "ENTITY_EXPERIENCE_ORB_PICKUP");
        this.soundDeny = plugin.getConfig().getString("tpa.sounds.deny", "ENTITY_EXPERIENCE_ORB_PICKUP");
        this.soundTeleport = plugin.getConfig().getString("tpa.sounds.teleport", "ENTITY_EXPERIENCE_ORB_PICKUP");
    }

    private int getInt(String path, int def) {
        return this.plugin.getConfig().getInt("tpa." + path, def);
    }

    private boolean getBool(String path, boolean def) {
        return this.plugin.getConfig().getBoolean("tpa." + path, def);
    }

    private double getDouble(String path, double def) {
        return this.plugin.getConfig().getDouble("tpa." + path, def);
    }
}

