/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.auction;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.auction.AuctionItem;
import net.lunark.io.auction.AuctionStorage;
import net.lunark.io.commands.config.AuctionConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class AuctionGUIListener
implements Listener {
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final AuctionConfig config;
    private final AuctionStorage storage;
    private final Economy economy;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final Map<Player, Map<Integer, UUID>> auctionViewingMap = new WeakHashMap<Player, Map<Integer, UUID>>();
    private final Map<Player, Map<Integer, UUID>> playerItemsViewingMap = new WeakHashMap<Player, Map<Integer, UUID>>();
    private final Map<Player, UUID> pendingRemovalMap = new WeakHashMap<Player, UUID>();

    public AuctionGUIListener(Plugin plugin, PlayerLanguageManager langManager, AuctionConfig config, AuctionStorage storage, Economy economy) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.config = config;
        this.storage = storage;
        this.economy = economy;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = event.getView().getTitle();
        if (!(title.contains("Auction House") || title.contains("Your Items") || title.contains("Confirm Removal"))) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType().isAir()) {
            return;
        }
        if (title.contains("Confirm Removal")) {
            this.handleConfirmRemoval(player, clicked);
            return;
        }
        if (this.handleNavigation(player, clicked, title)) {
            return;
        }
        if (title.contains("Your Items")) {
            this.handlePlayerItemClick(player, event.getRawSlot());
        } else if (title.contains("Auction House")) {
            this.handleAuctionItemClick(player, event.getRawSlot());
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        this.auctionViewingMap.remove(player);
        this.playerItemsViewingMap.remove(player);
        this.pendingRemovalMap.remove(player);
    }

    private void handleConfirmRemoval(Player player, ItemStack clicked) {
        UUID itemId = this.pendingRemovalMap.remove(player);
        if (itemId == null) {
            return;
        }
        if (clicked.getType() == Material.GREEN_WOOL) {
            this.storage.getItemData(itemId).thenAccept(optItem -> {
                if (optItem.isEmpty()) {
                    player.sendMessage(this.langManager.getMessageFor(player, "auction.gui.remove.not-found", "<red>Item no longer exists!", new LanguageManager.ComponentPlaceholder[0]));
                    return;
                }
                AuctionItem item = (AuctionItem)optItem.get();
                this.storage.removeItem(itemId).thenAccept(v -> Bukkit.getScheduler().runTask(this.plugin, () -> {
                    player.getInventory().addItem(new ItemStack[]{item.getItem().clone()});
                    player.sendMessage(this.langManager.getMessageFor(player, "auction.gui.remove.success", "<green>Item removed from auction and returned to your inventory.", new LanguageManager.ComponentPlaceholder[0]));
                    this.openPlayerItemsGUI(player, 1);
                }));
            });
        } else {
            player.sendMessage(this.langManager.getMessageFor(player, "auction.gui.remove.cancel", "<gray>Removal cancelled.", new LanguageManager.ComponentPlaceholder[0]));
            this.openPlayerItemsGUI(player, 1);
        }
    }

    private boolean handleNavigation(Player player, ItemStack clicked, String title) {
        return switch (clicked.getType()) {
            case Material.BARRIER -> {
                player.closeInventory();
                yield true;
            }
            case Material.ARROW -> {
                int newPage;
                int page = this.extractPage(title);
                int v1 = newPage = clicked.getItemMeta().getDisplayName().contains("Next") ? page + 1 : Math.max(page - 1, 1);
                if (title.contains("Your Items")) {
                    this.openPlayerItemsGUI(player, newPage);
                } else {
                    this.openAuctionGUI(player, newPage);
                }
                yield true;
            }
            case Material.PAPER -> {
                if (title.contains("Auction House")) {
                    int page = this.extractPage(title);
                    this.openAuctionGUI(player, page);
                    player.sendMessage(this.langManager.getMessageFor(player, "auction.gui.refresh", "<green>Auction refreshed!", new LanguageManager.ComponentPlaceholder[0]));
                }
                yield true;
            }
            case Material.CHEST -> {
                if (title.contains("Auction House")) {
                    this.openPlayerItemsGUI(player, 1);
                }
                yield true;
            }
            case Material.PLAYER_HEAD -> {
                if (title.contains("Auction House")) {
                    double balance = this.economy.getBalance((OfflinePlayer)player);
                    player.sendMessage(this.langManager.getMessageFor(player, "auction.gui.balance", "<green>Balance: <yellow>${balance}", LanguageManager.ComponentPlaceholder.of("{balance}", String.format("%.2f", balance))));
                }
                yield true;
            }
            default -> false;
        };
    }

    private void handlePlayerItemClick(Player player, int slot) {
        Map<Integer, UUID> slotMap = this.playerItemsViewingMap.get(player);
        if (slotMap == null) {
            return;
        }
        UUID itemId = slotMap.get(slot);
        if (itemId == null) {
            return;
        }
        this.pendingRemovalMap.put(player, itemId);
        this.openRemoveConfirmGUI(player);
    }

    private void handleAuctionItemClick(Player player, int slot) {
        Map<Integer, UUID> slotMap = this.auctionViewingMap.get(player);
        if (slotMap == null) {
            return;
        }
        UUID itemId = slotMap.get(slot);
        if (itemId == null) {
            return;
        }
        this.storage.getAllActiveItems().thenAccept(items -> {
            AuctionItem item = items.stream().filter(i -> i.getId().equals(itemId)).findFirst().orElse(null);
            if (item == null) {
                player.sendMessage(this.langManager.getMessageFor(player, "auction.purchase.not-found", "<red>Item no longer available!", new LanguageManager.ComponentPlaceholder[0]));
                return;
            }
            this.processPurchase(player, item);
        });
    }

    private void processPurchase(Player player, AuctionItem item) {
        double balance = this.economy.getBalance((OfflinePlayer)player);
        if (balance < item.getPrice()) {
            player.sendMessage(this.langManager.getMessageFor(player, "auction.purchase.not-enough-money", "<red>You don't have enough money!", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        CompletableFuture.runAsync(() -> {
            EconomyResponse withdrawResponse = this.economy.withdrawPlayer((OfflinePlayer)player, item.getPrice());
            if (!withdrawResponse.transactionSuccess()) {
                Bukkit.getScheduler().runTask(this.plugin, () -> player.sendMessage(this.langManager.getMessageFor(player, "auction.purchase.failed", "<red>Transaction failed: " + withdrawResponse.errorMessage, new LanguageManager.ComponentPlaceholder[0])));
                return;
            }
            EconomyResponse depositResponse = this.economy.depositPlayer(Bukkit.getOfflinePlayer((UUID)item.getSeller()), item.getPrice());
            if (!depositResponse.transactionSuccess()) {
                this.economy.depositPlayer((OfflinePlayer)player, item.getPrice());
                Bukkit.getScheduler().runTask(this.plugin, () -> player.sendMessage(this.langManager.getMessageFor(player, "auction.purchase.failed", "<red>Transaction failed: Could not pay seller", new LanguageManager.ComponentPlaceholder[0])));
                return;
            }
            ((CompletableFuture)this.storage.removeItem(item.getId()).thenAccept(v -> Bukkit.getScheduler().runTask(this.plugin, () -> {
                player.getInventory().addItem(new ItemStack[]{item.getItem().clone()});
                player.sendMessage(this.langManager.getMessageFor(player, "auction.purchase.success", "<green>Purchased for <yellow>${price}</yellow>!", LanguageManager.ComponentPlaceholder.of("{price}", String.format("%.2f", item.getPrice()))));
                int currentPage = this.extractPage(player.getOpenInventory().getTitle());
                this.openAuctionGUI(player, currentPage);
                Player seller = Bukkit.getPlayer((UUID)item.getSeller());
                if (seller != null && seller.isOnline()) {
                    seller.sendMessage(this.langManager.getMessageFor(seller, "auction.purchase.seller-message", "<green>{buyer} purchased your item for ${price}!", LanguageManager.ComponentPlaceholder.of("{buyer}", player.getName()), LanguageManager.ComponentPlaceholder.of("{price}", String.format("%.2f", item.getPrice()))));
                }
            }))).exceptionally(ex -> {
                Bukkit.getScheduler().runTask(this.plugin, () -> player.sendMessage(this.langManager.getMessageFor(player, "auction.purchase.failed", "<red>Failed to complete purchase. Please try again.", new LanguageManager.ComponentPlaceholder[0])));
                this.plugin.getLogger().severe("[Auction] Failed to remove item after purchase: " + ex.getMessage());
                return null;
            });
        });
    }

    private int extractPage(String title) {
        if (!title.contains("Page ")) {
            return 1;
        }
        String[] parts = title.split("Page ");
        if (parts.length < 2) {
            return 1;
        }
        String pageStr = parts[1].split(" ")[0].replace(")", "");
        try {
            return Integer.parseInt(pageStr);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public void openAuctionGUI(Player player, int page) {
        this.storage.getAllActiveItems().thenAccept(items -> Bukkit.getScheduler().runTask(this.plugin, () -> this.openAuctionGUISync(player, page, (List<AuctionItem>)items)));
    }

    private void openAuctionGUISync(Player player, int page, List<AuctionItem> items) {
        items = this.filterExpired(items);
        int totalPages = Math.max(1, (int)Math.ceil((double)items.size() / (double)this.config.itemsPerPage));
        page = Math.min(page, totalPages);
        Component title = this.langManager.getMessageFor(null, "auction.gui.titles.auction", this.config.guiTitle, LanguageManager.ComponentPlaceholder.of("{page}", page));
        Inventory inv = Bukkit.createInventory(null, (int)(this.config.guiRows * 9), (Component)title);
        this.addBorder(inv);
        HashMap<Integer, UUID> slotMap = new HashMap<Integer, UUID>();
        int start = (page - 1) * this.config.itemsPerPage;
        int end = Math.min(start + this.config.itemsPerPage, items.size());
        for (int i = start; i < end; ++i) {
            AuctionItem item = items.get(i);
            int slot = this.getSlot(i - start);
            slotMap.put(slot, item.getId());
            inv.setItem(slot, this.createDisplayItem(item, false));
        }
        this.auctionViewingMap.put(player, slotMap);
        inv.setItem(45, this.createGuiItem(Material.ARROW, "auction.gui.navigation.prev"));
        inv.setItem(0, this.createGuiItem(Material.PAPER, "auction.gui.navigation.refresh"));
        inv.setItem(4, this.createPlayerBalanceItem(player));
        inv.setItem(8, this.createGuiItem(Material.CHEST, "auction.gui.navigation.my-items"));
        inv.setItem(49, this.createGuiItem(Material.BARRIER, "auction.gui.navigation.close"));
        inv.setItem(53, this.createGuiItem(Material.ARROW, "auction.gui.navigation.next"));
        player.openInventory(inv);
    }

    public void openPlayerItemsGUI(Player player, int page) {
        this.storage.getPlayerItems(player.getUniqueId()).thenAccept(items -> Bukkit.getScheduler().runTask(this.plugin, () -> this.openPlayerItemsGUISync(player, page, (List<AuctionItem>)items)));
    }

    private void openPlayerItemsGUISync(Player player, int page, List<AuctionItem> items) {
        items = this.filterExpired(items);
        int totalPages = Math.max(1, (int)Math.ceil((double)items.size() / (double)this.config.itemsPerPage));
        page = Math.min(page, totalPages);
        Component title = this.langManager.getMessageFor(null, "auction.gui.titles.my-items", this.config.myItemsTitle, LanguageManager.ComponentPlaceholder.of("{page}", page));
        Inventory inv = Bukkit.createInventory(null, (int)(this.config.guiRows * 9), (Component)title);
        this.addBorder(inv);
        HashMap<Integer, UUID> slotMap = new HashMap<Integer, UUID>();
        int start = (page - 1) * this.config.itemsPerPage;
        int end = Math.min(start + this.config.itemsPerPage, items.size());
        for (int i = start; i < end; ++i) {
            AuctionItem item = items.get(i);
            int slot = this.getSlot(i - start);
            slotMap.put(slot, item.getId());
            inv.setItem(slot, this.createDisplayItem(item, true));
        }
        this.playerItemsViewingMap.put(player, slotMap);
        inv.setItem(45, this.createGuiItem(Material.ARROW, "auction.gui.navigation.prev"));
        inv.setItem(53, this.createGuiItem(Material.ARROW, "auction.gui.navigation.next"));
        inv.setItem(49, this.createGuiItem(Material.BARRIER, "auction.gui.navigation.close"));
        player.openInventory(inv);
    }

    private void openRemoveConfirmGUI(Player player) {
        Component title = this.langManager.getMessageFor(null, "auction.gui.titles.remove-confirm", this.config.removeConfirmTitle, new LanguageManager.ComponentPlaceholder[0]);
        Inventory inv = Bukkit.createInventory(null, (int)27, (Component)title);
        inv.setItem(11, this.createGuiItem(Material.GREEN_WOOL, "auction.gui.remove.confirm"));
        inv.setItem(15, this.createGuiItem(Material.RED_WOOL, "auction.gui.remove.cancel"));
        player.openInventory(inv);
    }

    private ItemStack createDisplayItem(AuctionItem item, boolean forSeller) {
        ItemStack display = item.getItem().clone();
        ItemMeta meta = display.getItemMeta();
        meta.displayName(this.langManager.getMessageFor(null, "auction.gui.item.name", "<green>Price: <yellow>${price}", LanguageManager.ComponentPlaceholder.of("{price}", String.format("%.2f", item.getPrice()))));
        ArrayList<Component> lore = new ArrayList<Component>();
        if (forSeller) {
            lore.add(this.langManager.getMessageFor(null, "auction.gui.item.lore.seller-price", "<gray>Your price: <yellow>${price}", LanguageManager.ComponentPlaceholder.of("{price}", String.format("%.2f", item.getPrice()))));
        } else {
            lore.add(this.langManager.getMessageFor(null, "auction.gui.item.lore.seller", "<gray>Seller: <yellow>{seller}", LanguageManager.ComponentPlaceholder.of("{seller}", this.getSellerName(item.getSeller()))));
        }
        lore.add(this.langManager.getMessageFor(null, "auction.gui.item.lore.expires", "<gray>Expires: <yellow>{date}", LanguageManager.ComponentPlaceholder.of("{date}", this.formatDate(item.getExpiration()))));
        lore.add(this.langManager.getMessageFor(null, forSeller ? "auction.gui.item.lore.seller-click" : "auction.gui.item.lore.buyer-click", forSeller ? "<yellow>Click to remove" : "<yellow>Click to purchase", new LanguageManager.ComponentPlaceholder[0]));
        meta.lore(lore);
        display.setItemMeta(meta);
        return display;
    }

    private ItemStack createGuiItem(Material material, String messageKey) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        Component nameComponent = this.langManager.getMessageFor(null, messageKey, "<white>Navigation", new LanguageManager.ComponentPlaceholder[0]);
        meta.displayName(nameComponent);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createPlayerBalanceItem(Player player) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta meta = skull.getItemMeta();
        double balance = this.economy.getBalance((OfflinePlayer)player);
        Component nameComponent = this.langManager.getMessageFor(player, "auction.gui.balance", "<green>Balance: <yellow>${balance}", LanguageManager.ComponentPlaceholder.of("{balance}", String.format("%.2f", balance)));
        meta.displayName(nameComponent);
        skull.setItemMeta(meta);
        return skull;
    }

    private void addBorder(Inventory inv) {
        int i;
        ItemStack glass = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta meta = glass.getItemMeta();
        meta.displayName((Component)Component.empty());
        glass.setItemMeta(meta);
        int size = inv.getSize();
        for (i = 0; i < 9; ++i) {
            inv.setItem(i, glass);
        }
        for (i = size - 9; i < size; ++i) {
            inv.setItem(i, glass);
        }
        for (i = 9; i < size - 9; i += 9) {
            inv.setItem(i, glass);
            inv.setItem(i + 8, glass);
        }
    }

    private int getSlot(int index) {
        return (index / 7 + 1) * 9 + index % 7 + 1;
    }

    private String getSellerName(UUID sellerId) {
        return Optional.ofNullable(Bukkit.getOfflinePlayer((UUID)sellerId).getName()).orElse("Unknown");
    }

    private String formatDate(long timestamp) {
        return LocalDate.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault()).format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    private List<AuctionItem> filterExpired(List<AuctionItem> items) {
        long now = System.currentTimeMillis();
        return items.stream().filter(item -> item.getExpiration() > now).toList();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String itemStackToBase64(ItemStack item) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String string;
            try (BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);){
                dataOutput.writeObject((Object)item);
                string = Base64Coder.encodeLines(outputStream.toByteArray());
            }
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to save item stack", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ItemStack base64ToItemStack(String base64) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines(base64));){
            ItemStack itemStack;
            try (BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);){
                itemStack = (ItemStack)dataInput.readObject();
            }
            return itemStack;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load item stack", e);
        }
    }
}

