/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.back;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.lunark.io.back.BackDataStorage;
import org.bukkit.Location;

public class BackManager {
    private final Map<UUID, Location> backLocations = new HashMap<UUID, Location>();
    private final BackDataStorage storage;

    public BackManager(BackDataStorage storage) {
        this.storage = storage;
    }

    public CompletableFuture<Void> setLastLocation(UUID uuid, Location location) {
        if (location == null || location.getWorld() == null) {
            return CompletableFuture.completedFuture(null);
        }
        Location cloned = location.clone();
        this.backLocations.put(uuid, cloned);
        return this.storage.saveBackLocation(uuid, cloned);
    }

    public CompletableFuture<Location> getLastLocation(UUID uuid) {
        Location cached = this.backLocations.get(uuid);
        if (cached != null) {
            return CompletableFuture.completedFuture(cached.clone());
        }
        return this.storage.loadBackLocation(uuid).thenApply(opt -> {
            if (opt.isPresent()) {
                Location loaded = (Location)opt.get();
                this.backLocations.put(uuid, loaded);
                return loaded.clone();
            }
            return null;
        });
    }

    public CompletableFuture<Boolean> hasBack(UUID uuid) {
        if (this.backLocations.containsKey(uuid)) {
            return CompletableFuture.completedFuture(true);
        }
        return this.storage.hasBackLocation(uuid);
    }

    public CompletableFuture<Void> clearBack(UUID uuid) {
        this.backLocations.remove(uuid);
        return this.storage.deleteBackLocation(uuid);
    }

    public void loadAllBackLocations() {
    }
}

